/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.TotalFacetCounts;
import org.apache.lucene.facet.search.cache.CategoryListCache;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public final class TotalFacetCountsCache {
    public static final int DEFAULT_CACHE_SIZE = 2;
    private static final TotalFacetCountsCache singleton = new TotalFacetCountsCache();
    private ConcurrentHashMap<TFCKey, TotalFacetCounts> cache = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<TFCKey> lruKeys = new ConcurrentLinkedQueue();
    private int maxCacheSize = 2;

    public static TotalFacetCountsCache getSingleton() {
        return singleton;
    }

    private TotalFacetCountsCache() {
    }

    public TotalFacetCounts getTotalCounts(IndexReader indexReader, TaxonomyReader taxonomy, FacetIndexingParams facetIndexingParams, CategoryListCache clCache) throws IOException {
        TFCKey key = new TFCKey(indexReader, taxonomy, facetIndexingParams);
        TotalFacetCounts tfc = this.cache.get(key);
        if (tfc != null) {
            this.markRecentlyUsed(key);
            return tfc;
        }
        return this.computeAndCache(key, clCache);
    }

    private void markRecentlyUsed(TFCKey key) {
        this.lruKeys.remove(key);
        this.lruKeys.add(key);
    }

    private synchronized void trimCache() {
        while (this.cache.size() > this.maxCacheSize) {
            TFCKey key = this.lruKeys.poll();
            if (key == null) {
                key = this.cache.keys().nextElement();
            }
            this.cache.remove(key);
        }
    }

    private synchronized TotalFacetCounts computeAndCache(TFCKey key, CategoryListCache clCache) throws IOException {
        TotalFacetCounts tfc = this.cache.get(key);
        if (tfc == null) {
            tfc = TotalFacetCounts.compute(key.indexReader, key.taxonomy, key.facetIndexingParams, clCache);
            this.lruKeys.add(key);
            this.cache.put(key, tfc);
            this.trimCache();
        }
        return tfc;
    }

    public synchronized void load(File inputFile, IndexReader indexReader, TaxonomyReader taxonomy, FacetIndexingParams facetIndexingParams) throws IOException {
        if (!(inputFile.isFile() && inputFile.exists() && inputFile.canRead())) {
            throw new IllegalArgumentException("Exepecting an existing readable file: " + inputFile);
        }
        TFCKey key = new TFCKey(indexReader, taxonomy, facetIndexingParams);
        TotalFacetCounts tfc = TotalFacetCounts.loadFromFile(inputFile, taxonomy, facetIndexingParams);
        this.cache.put(key, tfc);
        this.trimCache();
        this.markRecentlyUsed(key);
    }

    public void store(File outputFile, IndexReader indexReader, TaxonomyReader taxonomy, FacetIndexingParams facetIndexingParams, CategoryListCache clCache) throws IOException {
        File parentFile = outputFile.getParentFile();
        if (!((!outputFile.exists() || outputFile.isFile() && outputFile.canWrite()) && (outputFile.exists() || parentFile.isDirectory() && parentFile.canWrite()))) {
            throw new IllegalArgumentException("Exepecting a writable file: " + outputFile);
        }
        TotalFacetCounts tfc = this.getTotalCounts(indexReader, taxonomy, facetIndexingParams, clCache);
        TotalFacetCounts.storeToFile(outputFile, tfc);
    }

    public synchronized void clear() {
        this.cache.clear();
        this.lruKeys.clear();
    }

    public int getCacheSize() {
        return this.maxCacheSize;
    }

    public void setCacheSize(int size) {
        if (size < 1) {
            size = 1;
        }
        int origSize = this.maxCacheSize;
        this.maxCacheSize = size;
        if (this.maxCacheSize < origSize) {
            this.trimCache();
        }
    }

    private static class TFCKey {
        final IndexReader indexReader;
        final TaxonomyReader taxonomy;
        private final Iterable<CategoryListParams> clps;
        private final int hashCode;
        private final int nDels;
        final FacetIndexingParams facetIndexingParams;

        public TFCKey(IndexReader indexReader, TaxonomyReader taxonomy, FacetIndexingParams facetIndexingParams) {
            this.indexReader = indexReader;
            this.taxonomy = taxonomy;
            this.facetIndexingParams = facetIndexingParams;
            this.clps = facetIndexingParams.getAllCategoryListParams();
            this.nDels = indexReader.numDeletedDocs();
            this.hashCode = indexReader.hashCode() ^ taxonomy.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            TFCKey o = (TFCKey)other;
            if (this.indexReader != o.indexReader || this.taxonomy != o.taxonomy || this.nDels != o.nDels) {
                return false;
            }
            Iterator<CategoryListParams> it1 = this.clps.iterator();
            Iterator<CategoryListParams> it2 = o.clps.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (it1.next().equals(it2.next())) continue;
                return false;
            }
            return it1.hasNext() == it2.hasNext();
        }
    }
}

