/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.util.logging.LogFactory;

public class LocateStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(LocateStatement.class, Log.class);
    final KeyData keyData;
    private final List<Option> options;

    public LocateStatement(List<Option> options, KeyData key) {
        this.options = options;
        this.keyData = key;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        DistributionManager distributionManager;
        Cache cache = session.getCache(this.keyData.getCacheName());
        Codec codec = session.getCodec();
        if (this.options.size() > 0) {
            for (Option option : this.options) {
                switch (option.toEnum(Options.class)) {
                    case CODEC: {
                        if (option.getParameter() == null) {
                            throw log.missingOptionParameter(option.getName());
                        }
                        codec = session.getCodec(option.getParameter());
                    }
                }
            }
        }
        if ((distributionManager = cache.getAdvancedCache().getDistributionManager()) != null) {
            Object key = this.keyData.getKey();
            List addresses = distributionManager.locate(codec.encodeKey(key));
            return new StringResult(addresses.toString());
        }
        throw log.cacheNotDistributed();
    }

    private static enum Options {
        CODEC;

    }
}

