/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.IsCallerInRoleOperation;
import org.jboss.as.domain.management.access.PrincipalResourceDefinition;
import org.jboss.as.domain.management.access.RoleIncludeAllWriteAttributeHander;
import org.jboss.as.domain.management.access.RoleMappingAdd;
import org.jboss.as.domain.management.access.RoleMappingRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RoleMappingResourceDefinition
extends SimpleResourceDefinition {
    public static final String PATH_KEY = "role-mapping";
    public static final SimpleAttributeDefinition INCLUDE_ALL = new SimpleAttributeDefinitionBuilder("include-all", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false)).build();
    private final DelegatingConfigurableAuthorizer authorizer;

    private RoleMappingResourceDefinition(DelegatingConfigurableAuthorizer authorizer, boolean domainMode) {
        super(PathElement.pathElement((String)PATH_KEY), DomainManagementResolver.getResolver("core.access-control.role-mapping"), RoleMappingAdd.create(authorizer.getWritableAuthorizerConfiguration(), domainMode), RoleMappingRemove.create(authorizer.getWritableAuthorizerConfiguration()));
        this.authorizer = authorizer;
    }

    public static SimpleResourceDefinition create(DelegatingConfigurableAuthorizer authorizer, boolean domainMode) {
        return new RoleMappingResourceDefinition(authorizer, domainMode);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WritableAuthorizerConfiguration authorizerConfiguration = this.authorizer.getWritableAuthorizerConfiguration();
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)INCLUDE_ALL, null, (OperationStepHandler)new RoleIncludeAllWriteAttributeHander(authorizerConfiguration));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        WritableAuthorizerConfiguration authorizerConfiguration = this.authorizer.getWritableAuthorizerConfiguration();
        resourceRegistration.registerSubModel((ResourceDefinition)PrincipalResourceDefinition.includeResourceDefinition(authorizerConfiguration));
        resourceRegistration.registerSubModel((ResourceDefinition)PrincipalResourceDefinition.excludeResourceDefinition(authorizerConfiguration));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)IsCallerInRoleOperation.DEFINITION, IsCallerInRoleOperation.create((Authorizer)this.authorizer));
    }

    static String getRoleName(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        for (PathElement current : address) {
            if (!PATH_KEY.equals(current.getKey())) continue;
            return current.getValue();
        }
        throw new IllegalStateException();
    }
}

