/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.runner.AbstractPatchingTask;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

abstract class AbstractFileTask
extends AbstractPatchingTask<MiscContentItem> {
    final File target;
    final File backup;

    protected AbstractFileTask(PatchingTaskDescription description, File target, File backup) {
        super(description, MiscContentItem.class);
        this.target = target;
        this.backup = backup;
    }

    abstract ContentModification createRollbackEntry(ContentModification var1, MiscContentItem var2, byte[] var3);

    @Override
    byte[] backup(PatchingTaskContext context) throws IOException {
        if (this.target.isFile()) {
            byte[] backupHash = IoUtils.copy(this.target, this.backup);
            return backupHash;
        }
        if (((MiscContentItem)this.contentItem).isDirectory() && this.target.isDirectory()) {
            this.setIgnoreApply();
        }
        return IoUtils.NO_CONTENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] apply(PatchingTaskContext context, PatchContentLoader loader) throws IOException {
        MiscContentItem item = (MiscContentItem)this.contentItem;
        if (item.isDirectory()) {
            if (!this.target.mkdirs() && !this.target.isDirectory()) {
                throw PatchMessages.MESSAGES.cannotCreateDirectory(this.target.getAbsolutePath());
            }
            return IoUtils.NO_CONTENT;
        }
        if (!this.target.exists()) {
            AbstractFileTask.createParentDirectories(this.target, item.getPath(), item.getPath().length, context);
        }
        InputStream is = loader.openContentStream(item);
        try {
            byte[] byArray = IoUtils.copy(is, this.target);
            return byArray;
        }
        finally {
            IoUtils.safeClose(is);
        }
    }

    @Override
    ContentModification createRollbackEntry(ContentModification original, byte[] targetHash, byte[] itemHash) {
        MiscContentItem item = new MiscContentItem(((MiscContentItem)this.contentItem).getName(), ((MiscContentItem)this.contentItem).getPath(), itemHash, ((MiscContentItem)this.contentItem).isDirectory(), ((MiscContentItem)this.contentItem).isAffectsRuntime());
        return this.createRollbackEntry(original, item, targetHash);
    }

    static void createParentDirectories(File target, String[] path, int depth, PatchingTaskContext context) throws IOException {
        if (depth > 0) {
            File parent = target.getParentFile();
            if (!parent.exists()) {
                AbstractFileTask.createParentDirectories(parent, path, depth - 1, context);
            }
            if (!parent.mkdir() && !parent.isDirectory()) {
                throw PatchMessages.MESSAGES.cannotCreateDirectory(target.getAbsolutePath());
            }
        }
    }
}

