/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchInfo;
import org.jboss.as.patching.PatchLogger;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.ZipUtils;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.BundledPatch;
import org.jboss.as.patching.metadata.PatchBundleXml;
import org.jboss.as.patching.metadata.PatchMetadataResolver;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.runner.IdentityPatchRunner;
import org.jboss.as.patching.runner.PatchContentProvider;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchTool;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.as.patching.tool.PatchingResult;

public class PatchToolImpl
implements PatchTool {
    private final InstallationManager manager;
    private final InstallationManager.ModificationCompletionCallback callback;
    private final IdentityPatchRunner runner;

    public PatchToolImpl(InstallationManager manager) {
        this.manager = manager;
        this.runner = new IdentityPatchRunner(manager.getInstalledImage());
        this.callback = this.runner;
    }

    public PatchToolImpl(InstallationManager manager, InstallationManager.ModificationCompletionCallback callback) {
        this.manager = manager;
        this.runner = new IdentityPatchRunner(manager.getInstalledImage());
        this.callback = callback;
    }

    @Override
    public PatchInfo getPatchInfo() {
        try {
            final Identity identity = this.manager.getIdentity();
            final PatchableTarget.TargetInfo info = this.manager.getIdentity().loadTargetInfo();
            return new PatchInfo(){

                @Override
                public String getVersion() {
                    return identity.getVersion();
                }

                @Override
                public String getCumulativePatchID() {
                    return info.getCumulativePatchID();
                }

                @Override
                public List<String> getPatchIDs() {
                    return info.getPatchIDs();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PatchingHistory getPatchingHistory() {
        return PatchingHistory.Factory.getHistory(this.manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchingResult applyPatch(File file, ContentVerificationPolicy contentPolicy) throws PatchingException {
        PatchingResult patchingResult;
        block11: {
            File patchXml;
            if (file.isDirectory() && (patchXml = new File(file, "patch.xml")).exists()) {
                return this.execute(file, contentPolicy);
            }
            FileInputStream is = new FileInputStream(file);
            try {
                patchingResult = this.applyPatch(is, contentPolicy);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {
                            PatchLogger.ROOT_LOGGER.debugf(e, "failed to close input stream", new Object[0]);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw PatchToolImpl.rethrowException(e);
                }
            }
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                PatchLogger.ROOT_LOGGER.debugf(e, "failed to close input stream", new Object[0]);
            }
        }
        return patchingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchingResult applyPatch(URL url, ContentVerificationPolicy contentPolicy) throws PatchingException {
        PatchingResult patchingResult;
        block10: {
            InputStream is = url.openStream();
            try {
                patchingResult = this.applyPatch(is, contentPolicy);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            PatchLogger.ROOT_LOGGER.debugf(e, "failed to close input stream", new Object[0]);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PatchingException(e);
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                PatchLogger.ROOT_LOGGER.debugf(e, "failed to close input stream", new Object[0]);
            }
        }
        return patchingResult;
    }

    @Override
    public PatchingResult applyPatch(InputStream is, ContentVerificationPolicy contentPolicy) throws PatchingException {
        return this.applyPatch(null, is, contentPolicy);
    }

    private PatchingResult applyPatch(File parentWorkDir, InputStream is, ContentVerificationPolicy contentPolicy) throws PatchingException {
        File workDir = null;
        try {
            workDir = parentWorkDir == null ? IdentityPatchRunner.createTempDir() : IdentityPatchRunner.createTempDir(parentWorkDir);
            File cachedContent = new File(workDir, "content");
            IoUtils.copy(is, cachedContent);
            ZipUtils.unzip(cachedContent, workDir);
            PatchingResult patchingResult = this.execute(workDir, contentPolicy);
            return patchingResult;
        }
        catch (Exception e) {
            throw PatchToolImpl.rethrowException(e);
        }
        finally {
            if (workDir != null && !IoUtils.recursiveDelete(workDir)) {
                PatchLogger.ROOT_LOGGER.cannotDeleteFile(workDir.getAbsolutePath());
            }
        }
    }

    @Override
    public PatchingResult rollback(String patchId, ContentVerificationPolicy contentPolicy, boolean rollbackTo, boolean resetConfiguration) throws PatchingException {
        InstallationManager.InstallationModification modification = this.manager.modifyInstallation(this.runner);
        try {
            return this.runner.rollbackPatch(patchId, contentPolicy, rollbackTo, resetConfiguration, modification);
        }
        catch (Exception e) {
            modification.cancel();
            throw PatchToolImpl.rethrowException(e);
        }
    }

    @Override
    public PatchingResult rollbackLast(ContentVerificationPolicy contentPolicy, boolean resetConfiguration) throws PatchingException {
        InstallationManager.InstallationModification modification = this.manager.modifyInstallation(this.runner);
        try {
            return this.runner.rollbackLast(contentPolicy, resetConfiguration, modification);
        }
        catch (Exception e) {
            modification.cancel();
            throw PatchToolImpl.rethrowException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PatchingResult execute(File workDir, ContentVerificationPolicy contentPolicy) throws PatchingException, IOException, XMLStreamException {
        PatchMetadataResolver patchResolver;
        File patchBundleXml = new File(workDir, "patches.xml");
        if (patchBundleXml.exists()) {
            FileInputStream patchIs = new FileInputStream(patchBundleXml);
            try {
                BundledPatch bundledPatch = PatchBundleXml.parse(patchIs);
                PatchingResult patchingResult = this.applyPatchBundle(workDir, bundledPatch, contentPolicy);
                return patchingResult;
            }
            finally {
                IoUtils.safeClose(patchIs);
            }
        }
        File patchXml = new File(workDir, "patch.xml");
        PatchContentProvider.DefaultContentProvider contentProvider = PatchContentProvider.DefaultContentProvider.create(workDir);
        FileInputStream patchIS = new FileInputStream(patchXml);
        try {
            patchResolver = PatchXml.parse(patchIS);
            ((InputStream)patchIS).close();
        }
        finally {
            IoUtils.safeClose(patchIS);
        }
        return this.apply(patchResolver, contentProvider, contentPolicy);
    }

    protected PatchingResult apply(PatchMetadataResolver patchResolver, PatchContentProvider contentProvider, ContentVerificationPolicy contentPolicy) throws PatchingException {
        InstallationManager.InstallationModification modification = this.manager.modifyInstallation(this.callback);
        try {
            return this.runner.applyPatch(patchResolver, contentProvider, contentPolicy, modification);
        }
        catch (Exception e) {
            modification.cancel();
            throw PatchToolImpl.rethrowException(e);
        }
    }

    protected PatchingResult applyPatchBundle(File workDir, BundledPatch bundledPatch, ContentVerificationPolicy contentPolicy) throws PatchingException, IOException {
        PatchingResult result = null;
        ArrayList<BundledPatch.BundledPatchEntry> results = new ArrayList<BundledPatch.BundledPatchEntry>();
        Iterator<BundledPatch.BundledPatchEntry> iterator = bundledPatch.getPatches().iterator();
        while (iterator.hasNext()) {
            BundledPatch.BundledPatchEntry entry = iterator.next();
            if (this.manager.getAllInstalledPatches().contains(entry.getPatchId())) continue;
            File patch = new File(workDir, entry.getPatchPath());
            FileInputStream is = new FileInputStream(patch);
            try {
                result = this.applyPatch(workDir, is, contentPolicy);
            }
            catch (PatchingException e) {
                for (BundledPatch.BundledPatchEntry committed : results) {
                    try {
                        this.rollback(committed.getPatchId(), contentPolicy, false, false).commit();
                    }
                    catch (PatchingException oe) {
                        PatchLogger.ROOT_LOGGER.debugf(oe, "failed to rollback patch '%s'", committed.getPatchId());
                    }
                }
                throw e;
            }
            finally {
                IoUtils.safeClose(is);
            }
            if (!iterator.hasNext()) continue;
            result.commit();
            results.add(0, entry);
        }
        if (result == null) {
            throw new PatchingException();
        }
        return new WrappedMultiInstallPatch(result, contentPolicy, results);
    }

    static PatchingException rethrowException(Exception e) {
        if (e instanceof PatchingException) {
            return (PatchingException)e;
        }
        return new PatchingException(e);
    }

    class WrappedMultiInstallPatch
    implements PatchingResult {
        private final PatchingResult last;
        private final ContentVerificationPolicy policy;
        private final List<BundledPatch.BundledPatchEntry> committed;

        WrappedMultiInstallPatch(PatchingResult last, ContentVerificationPolicy policy, List<BundledPatch.BundledPatchEntry> committed) {
            this.last = last;
            this.policy = policy;
            this.committed = committed;
        }

        @Override
        public String getPatchId() {
            return this.last.getPatchId();
        }

        @Override
        public PatchInfo getPatchInfo() {
            return this.last.getPatchInfo();
        }

        @Override
        public void commit() {
            this.last.commit();
        }

        @Override
        public void rollback() {
            this.last.rollback();
            for (BundledPatch.BundledPatchEntry entry : this.committed) {
                try {
                    PatchToolImpl.this.rollback(entry.getPatchId(), this.policy, false, false).commit();
                }
                catch (Exception e) {
                    PatchLogger.ROOT_LOGGER.debugf(e, "failed to rollback patch '%s'", entry.getPatchId());
                }
            }
        }
    }
}

