/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResource;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public abstract class ClusteredCacheAdd
extends CacheAdd {
    ClusteredCacheAdd(CacheMode mode) {
        super(mode);
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        super.populate(fromModel, toModel);
        ClusteredCacheResource.MODE.validateAndSet(fromModel, toModel);
        ClusteredCacheResource.ASYNC_MARSHALLING.validateAndSet(fromModel, toModel);
        ClusteredCacheResource.QUEUE_SIZE.validateAndSet(fromModel, toModel);
        ClusteredCacheResource.QUEUE_FLUSH_INTERVAL.validateAndSet(fromModel, toModel);
        ClusteredCacheResource.REMOTE_TIMEOUT.validateAndSet(fromModel, toModel);
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, List<CacheAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, cache, builder, dependencies);
        Mode mode = Mode.valueOf(ClusteredCacheResource.MODE.resolveModelAttribute(context, cache).asString());
        long remoteTimeout = ClusteredCacheResource.REMOTE_TIMEOUT.resolveModelAttribute(context, cache).asLong();
        int queueSize = ClusteredCacheResource.QUEUE_SIZE.resolveModelAttribute(context, cache).asInt();
        long queueFlushInterval = ClusteredCacheResource.QUEUE_FLUSH_INTERVAL.resolveModelAttribute(context, cache).asLong();
        boolean asyncMarshalling = ClusteredCacheResource.ASYNC_MARSHALLING.resolveModelAttribute(context, cache).asBoolean();
        CacheMode cacheMode = mode.apply(this.mode);
        builder.clustering().cacheMode(cacheMode);
        if (cacheMode.isSynchronous()) {
            builder.clustering().sync().replTimeout(remoteTimeout);
        } else {
            builder.clustering().async().useReplQueue(queueSize > 0);
            builder.clustering().async().replQueueMaxElements(queueSize);
            builder.clustering().async().replQueueInterval(queueFlushInterval);
            if (asyncMarshalling) {
                builder.clustering().async().asyncMarshalling();
            } else {
                builder.clustering().async().syncMarshalling();
            }
        }
    }
}

