/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;

public class JdbcIsolationDelegate
implements IsolationDelegate {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(JdbcIsolationDelegate.class);
    private final TransactionCoordinator transactionCoordinator;

    public JdbcIsolationDelegate(TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
    }

    protected JdbcConnectionAccess jdbcConnectionAccess() {
        return this.transactionCoordinator.getTransactionContext().getJdbcConnectionAccess();
    }

    protected SqlExceptionHelper sqlExceptionHelper() {
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().getJdbcServices().getSqlExceptionHelper();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T delegateWork(WorkExecutorVisitable<T> work, boolean transacted) throws HibernateException {
        boolean wasAutoCommit = false;
        try {
            Connection connection = this.jdbcConnectionAccess().obtainConnection();
            try {
                if (transacted && connection.getAutoCommit()) {
                    wasAutoCommit = true;
                    connection.setAutoCommit(false);
                }
                Object result = work.accept(new WorkExecutor(), connection);
                if (transacted) {
                    connection.commit();
                }
                Object t = result;
                return t;
            }
            catch (Exception e) {
                try {
                    if (transacted && !connection.isClosed()) {
                        connection.rollback();
                    }
                }
                catch (Exception ignore) {
                    LOG.unableToRollbackConnection(ignore);
                }
                if (e instanceof HibernateException) {
                    throw (HibernateException)e;
                }
                if (!(e instanceof SQLException)) throw new HibernateException("error performing isolated work", e);
                throw this.sqlExceptionHelper().convert((SQLException)e, "error performing isolated work");
            }
            finally {
                if (transacted && wasAutoCommit) {
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (Exception ignore) {
                        LOG.trace("was unable to reset connection back to auto-commit");
                    }
                }
                try {
                    this.jdbcConnectionAccess().releaseConnection(connection);
                }
                catch (Exception ignore) {
                    LOG.unableToReleaseIsolatedConnection(ignore);
                }
            }
        }
        catch (SQLException sqle) {
            throw this.sqlExceptionHelper().convert(sqle, "unable to obtain isolated JDBC connection");
        }
    }
}

