/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.conduits.ReadTimeoutStreamSourceConduit;
import io.undertow.conduits.WriteTimeoutStreamSinkConduit;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.http.HttpReadListener;
import io.undertow.server.protocol.http.HttpRequestParser;
import io.undertow.server.protocol.http.HttpServerConnection;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class HttpOpenListener
implements ChannelListener<StreamConnection>,
DelegateOpenListener {
    private final Pool<ByteBuffer> bufferPool;
    private final int bufferSize;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile HttpRequestParser parser;

    @Deprecated
    public HttpOpenListener(Pool<ByteBuffer> pool, int bufferSize) {
        this(pool, OptionMap.EMPTY);
    }

    @Deprecated
    public HttpOpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions, int bufferSize) {
        this(pool, undertowOptions);
    }

    public HttpOpenListener(Pool<ByteBuffer> pool) {
        this(pool, OptionMap.EMPTY);
    }

    public HttpOpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        Pooled buf = pool.allocate();
        this.bufferSize = ((ByteBuffer)buf.getResource()).remaining();
        buf.free();
        this.parser = HttpRequestParser.instance(undertowOptions);
    }

    public void handleEvent(StreamConnection channel) {
        this.handleEvent(channel, null);
    }

    @Override
    public void handleEvent(StreamConnection channel, Pooled<ByteBuffer> buffer) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", channel.getPeerAddress());
        }
        try {
            Integer writeTimeout;
            Integer readTimeout = (Integer)channel.getOption(Options.READ_TIMEOUT);
            Integer idleTimeout = (Integer)this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
            if ((readTimeout == null || readTimeout <= 0) && idleTimeout != null) {
                readTimeout = idleTimeout;
            } else if (readTimeout != null && idleTimeout != null && idleTimeout > 0) {
                readTimeout = Math.min(readTimeout, idleTimeout);
            }
            if (readTimeout != null && readTimeout > 0) {
                channel.getSourceChannel().setConduit((StreamSourceConduit)new ReadTimeoutStreamSourceConduit(channel.getSourceChannel().getConduit(), channel, this));
            }
            if (((writeTimeout = (Integer)channel.getOption(Options.WRITE_TIMEOUT)) == null || writeTimeout <= 0) && idleTimeout != null) {
                writeTimeout = idleTimeout;
            } else if (writeTimeout != null && idleTimeout != null && idleTimeout > 0) {
                writeTimeout = Math.min(writeTimeout, idleTimeout);
            }
            if (writeTimeout != null && writeTimeout > 0) {
                channel.getSinkChannel().setConduit((StreamSinkConduit)new WriteTimeoutStreamSinkConduit(channel.getSinkChannel().getConduit(), channel, this));
            }
        }
        catch (IOException e) {
            IoUtils.safeClose((Closeable)channel);
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        }
        HttpServerConnection connection = new HttpServerConnection(channel, this.bufferPool, this.rootHandler, this.undertowOptions, this.bufferSize);
        HttpReadListener readListener = new HttpReadListener(connection, this.parser);
        if (buffer != null) {
            if (((ByteBuffer)buffer.getResource()).hasRemaining()) {
                connection.setExtraBytes(buffer);
            } else {
                buffer.free();
            }
        }
        connection.setReadListener(readListener);
        readListener.newRequest();
        channel.getSourceChannel().setReadListener((ChannelListener)readListener);
        readListener.handleEvent(channel.getSourceChannel());
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        this.parser = HttpRequestParser.instance(undertowOptions);
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }
}

