/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jacorb.naming.namemanager.ContextNode;
import org.jacorb.naming.namemanager.NSPrefsDlg;
import org.jacorb.naming.namemanager.NSTree;
import org.jacorb.naming.namemanager.ObjectDialog;
import org.jacorb.naming.namemanager.Updater;
import org.omg.CORBA.UserException;

public class Handler
extends WindowAdapter
implements ActionListener,
MouseListener,
KeyListener {
    int updateInterval;
    NSTree tree;
    Component frame;
    JDialog dlg;
    JTextField editName;
    JPopupMenu popup;
    Updater updater;

    public Handler(Component fr, NSTree tr) {
        this.frame = fr;
        this.tree = tr;
        this.popup = new JPopupMenu();
        JMenuItem bindContext = new JMenuItem("BindNewContext");
        JMenuItem bindObject = new JMenuItem("Bind Object");
        JMenuItem unbind = new JMenuItem("Unbind name");
        this.popup.add(bindContext);
        this.popup.add(bindObject);
        this.popup.add(unbind);
        bindContext.addActionListener(this);
        bindObject.addActionListener(this);
        unbind.addActionListener(this);
        this.updateInterval = 10;
        this.updater = new Updater(this.tree, this.updateInterval);
        this.updater.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Quit")) {
            System.exit(0);
        } else if (e.getActionCommand().equals("Unbind name")) {
            this.tree.unbind();
        } else if (e.getActionCommand().equals("Bind Object")) {
            ObjectDialog dialog = new ObjectDialog((Frame)this.frame);
            if (dialog.isOk) {
                try {
                    this.tree.bindObject(dialog.getName(), dialog.getIOR(), dialog.isRebind());
                }
                catch (UserException ue) {
                    JOptionPane.showMessageDialog(this.frame, ue.getClass().getName() + (ue.getMessage() != null ? ":" + ue.getMessage() : ""), "Exception", 1);
                }
            }
        } else if (e.getActionCommand().equals("BindNewContext")) {
            try {
                String contextName = JOptionPane.showInputDialog(this.frame, "Name of the new context", "BindNewContext", 3);
                if (contextName != null && contextName.length() > 0) {
                    this.tree.bind(contextName);
                }
            }
            catch (UserException ue) {
                JOptionPane.showMessageDialog(this.frame, ue.getClass().getName() + (ue.getMessage() != null ? ":" + ue.getMessage() : ""), "Exception", 1);
            }
        } else if (e.getActionCommand().equals("About...")) {
            JOptionPane.showMessageDialog(this.frame, "JacORB NameManager 1.2\n(C) 1998-2004 Gerald Brose, Wei-ju Wu & Volker Siegel\nFreie Universitaet Berlin", "About", 1);
        } else if (e.getActionCommand().equals("Options")) {
            NSPrefsDlg dlg = new NSPrefsDlg((Frame)this.frame, this.updateInterval);
            dlg.pack();
            dlg.show();
            if (dlg.isOk) {
                this.updater.setSeconds(dlg.updateInterval);
            }
        } else {
            throw new RuntimeException("Should not happen");
        }
    }

    public void keyPressed(KeyEvent k) {
    }

    public void keyReleased(KeyEvent k) {
        if (k.getKeyCode() == 127) {
            this.tree.unbind();
        }
    }

    public void keyTyped(KeyEvent k) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || e.getModifiers() == 4) {
            this.popup.pack();
            this.popup.show(this.tree, e.getX(), e.getY());
        } else {
            TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
            if (path != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
                ((ContextNode)node.getUserObject()).display();
            }
        }
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }
}

