/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.as.pojo.PojoMessages;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ValueConfig;

public abstract class CollectionConfig
extends ValueConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String elementType;
    private List<ValueConfig> values = new ArrayList<ValueConfig>();
    private Class<?> collectionType;
    private Class<?> componentType;

    protected abstract Collection<Object> createDefaultInstance();

    protected Collection<Object> createInstance() {
        try {
            if (this.collectionType != null) {
                return (Collection)this.collectionType.newInstance();
            }
            return this.createDefaultInstance();
        }
        catch (Exception e) {
            throw PojoMessages.MESSAGES.cannotInstantiateCollection(e);
        }
    }

    @Override
    public void visit(ConfigVisitor visitor) {
        this.collectionType = CollectionConfig.getType(visitor, this.getType());
        this.componentType = CollectionConfig.getType(visitor, this.elementType);
        super.visit(visitor);
    }

    @Override
    protected void addChildren(ConfigVisitor visitor, List<ConfigVisitorNode> nodes) {
        nodes.addAll(this.values);
    }

    @Override
    protected Object getPtValue(ParameterizedType type) {
        Type ct = this.componentType;
        if (ct == null && type != null) {
            ct = CollectionConfig.getComponentType(type, 0);
        }
        Collection<Object> result = this.createInstance();
        for (ValueConfig vc : this.values) {
            result.add(vc.getValue(ct));
        }
        return result;
    }

    @Override
    protected Object getClassValue(Class<?> type) {
        Collection<Object> result = this.createInstance();
        for (ValueConfig vc : this.values) {
            result.add(vc.getValue(this.componentType));
        }
        return result;
    }

    public void setElementType(String elementType) {
        this.elementType = elementType;
    }

    public void addValue(ValueConfig value) {
        this.values.add(value);
    }
}

