/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.resource.InterfaceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class InterfaceCriteriaWriteHandler
implements OperationStepHandler {
    public static final InterfaceCriteriaWriteHandler UPDATE_RUNTIME = new InterfaceCriteriaWriteHandler(true);
    public static final InterfaceCriteriaWriteHandler CONFIG_ONLY = new InterfaceCriteriaWriteHandler(false);
    private static final Map<String, AttributeDefinition> ATTRIBUTES = new HashMap<String, AttributeDefinition>();
    private static final OperationStepHandler VERIFY_HANDLER = new ModelValidationStep();
    private static final ParametersValidator nameValidator = new ParametersValidator();
    private final boolean updateRuntime;

    private InterfaceCriteriaWriteHandler(boolean updateRuntime) {
        this.updateRuntime = updateRuntime;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        nameValidator.validate(operation);
        String attributeName = operation.require("name").asString();
        ModelNode newValue = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
        ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        AttributeDefinition attributeDefinition = ATTRIBUTES.get(attributeName);
        if (attributeDefinition == null) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownAttribute(attributeName)));
        }
        ModelNode syntheticOp = new ModelNode();
        syntheticOp.get(attributeName).set(newValue);
        attributeDefinition.validateAndSet(syntheticOp, submodel);
        if (this.updateRuntime) {
            context.reloadRequired();
        }
        context.addStep(VERIFY_HANDLER, OperationContext.Stage.MODEL);
        OperationContext.RollbackHandler rollbackHandler = this.updateRuntime ? OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER : OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER;
        context.completeStep(rollbackHandler);
    }

    static {
        for (AttributeDefinition def : InterfaceDefinition.ROOT_ATTRIBUTES) {
            ATTRIBUTES.put(def.getName(), def);
        }
    }

    static class ModelValidationStep
    implements OperationStepHandler {
        ModelValidationStep() {
        }

        @Override
        public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode model = resource.getModel();
            for (AttributeDefinition definition : InterfaceDefinition.ROOT_ATTRIBUTES) {
                String attributeName = definition.getName();
                boolean has = model.hasDefined(attributeName);
                if (!has && this.isRequired(definition, model)) {
                    throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.required(attributeName)));
                }
                if (!has || definition.getType() == ModelType.BOOLEAN && !model.get(attributeName).asBoolean() || this.isAllowed(definition, model)) continue;
                String[] alts = definition.getAlternatives();
                StringBuilder sb = null;
                if (alts != null) {
                    for (String alt : alts) {
                        if (!model.hasDefined(alt)) continue;
                        if (sb == null) {
                            sb = new StringBuilder();
                        } else {
                            sb.append(", ");
                        }
                        sb.append(alt);
                    }
                }
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalidAttributeCombo(attributeName, sb)));
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }

        boolean isRequired(AttributeDefinition def, ModelNode model) {
            boolean required;
            boolean bl = required = !def.isAllowNull();
            return required ? !this.hasAlternative(def.getAlternatives(), model, true) : required;
        }

        boolean isAllowed(AttributeDefinition def, ModelNode model) {
            String[] alternatives = def.getAlternatives();
            if (alternatives != null) {
                for (String alternative : alternatives) {
                    if (!model.hasDefined(alternative)) continue;
                    if (((AttributeDefinition)ATTRIBUTES.get(alternative)).getType() == ModelType.BOOLEAN) {
                        return !model.get(alternative).asBoolean();
                    }
                    return false;
                }
            }
            return true;
        }

        boolean hasAlternative(String[] alternatives, ModelNode operationObject, boolean ignoreBoolean) {
            if (alternatives != null) {
                for (String alternative : alternatives) {
                    if (!operationObject.hasDefined(alternative)) continue;
                    if (ignoreBoolean && operationObject.get(alternative).getType() == ModelType.BOOLEAN) {
                        return operationObject.get(alternative).asBoolean();
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

