/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderPrepareCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.totalorder.RetryPrepareException;
import org.infinispan.remoting.inboundhandler.BaseBlockingRunnable;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.transaction.impl.TotalOrderRemoteTransactionState;
import org.infinispan.transaction.totalorder.TotalOrderLatch;
import org.infinispan.transaction.totalorder.TotalOrderManager;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderTxPerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler {
    private static final Log log = LogFactory.getLog(TotalOrderTxPerCacheInboundInvocationHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    private TotalOrderManager totalOrderManager;

    @Inject
    public void injectTotalOrderManager(TotalOrderManager totalOrderManager) {
        this.totalOrderManager = totalOrderManager;
    }

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        try {
            BlockingRunnable runnable;
            int commandTopologyId = NO_TOPOLOGY_COMMAND;
            boolean onExecutorService = !order.preserveOrder() && command.canBlock();
            switch (command.getCommandId()) {
                case 2: {
                    commandTopologyId = TotalOrderTxPerCacheInboundInvocationHandler.extractCommandTopologyId((MultipleRpcCommand)command);
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, true, onExecutorService);
                    break;
                }
                case 1: {
                    commandTopologyId = TotalOrderTxPerCacheInboundInvocationHandler.extractCommandTopologyId((SingleRpcCommand)command);
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, true, onExecutorService);
                    break;
                }
                case 15: {
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, false, onExecutorService);
                    break;
                }
                case 38: 
                case 39: {
                    if (!this.stateTransferManager.ownsData()) {
                        log.debugf("No Data in local node.", new Object[0]);
                        reply.reply(null);
                        return;
                    }
                    TotalOrderRemoteTransactionState state = ((TotalOrderPrepareCommand)command).getOrCreateState();
                    this.totalOrderManager.ensureOrder(state, ((PrepareCommand)command).getAffectedKeysToLock(false));
                    runnable = this.createRunnableForPrepare(state, (PrepareCommand)command, reply);
                    onExecutorService = true;
                    break;
                }
                case 13: 
                case 35: 
                case 36: {
                    runnable = this.createRunnableForCommitOrRollback(command, reply);
                    break;
                }
                default: {
                    if (command instanceof TopologyAffectedCommand) {
                        commandTopologyId = TotalOrderTxPerCacheInboundInvocationHandler.extractCommandTopologyId((TopologyAffectedCommand)((Object)command));
                    }
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, true, onExecutorService);
                }
            }
            this.handleRunnable(runnable, onExecutorService);
        }
        catch (Throwable throwable) {
            reply.reply(this.exceptionHandlingCommand(command, throwable));
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected boolean isTraceEnabled() {
        return trace;
    }

    private BlockingRunnable createRunnableForPrepare(final TotalOrderRemoteTransactionState state, PrepareCommand command, Reply reply) {
        return new BaseBlockingRunnable(this, command, reply){

            @Override
            public boolean isReady() {
                for (TotalOrderLatch block : state.getConflictingTransactionBlocks()) {
                    if (!block.isBlocked()) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected void onException(Throwable throwable) {
                if (throwable instanceof RetryPrepareException) {
                    RetryPrepareException retry = (RetryPrepareException)((Object)throwable);
                    log.debugf((Throwable)((Object)retry), "Prepare [%s] conflicted with state transfer", this.command);
                    this.response = new ExceptionResponse((Exception)((Object)retry));
                }
                log.debugf("Exception received on prepare. Releasing state.", new Object[0]);
                TotalOrderTxPerCacheInboundInvocationHandler.this.totalOrderManager.release(state);
            }

            @Override
            protected void afterInvoke() {
                if (this.response instanceof ExceptionResponse) {
                    if (trace) {
                        log.trace("Exception received on prepare. Releasing state.");
                    }
                    TotalOrderTxPerCacheInboundInvocationHandler.this.totalOrderManager.release(state);
                }
            }

            @Override
            protected void onFinally() {
                if (((PrepareCommand)this.command).isOnePhaseCommit() || this.response instanceof ExceptionResponse) {
                    TotalOrderTxPerCacheInboundInvocationHandler.this.remoteCommandsExecutor.checkForReadyTasks();
                }
            }
        };
    }

    private BlockingRunnable createRunnableForCommitOrRollback(CacheRpcCommand command, Reply reply) {
        return new BaseBlockingRunnable(this, command, reply){

            @Override
            public boolean isReady() {
                return true;
            }

            @Override
            protected void onFinally() {
                TotalOrderTxPerCacheInboundInvocationHandler.this.remoteCommandsExecutor.checkForReadyTasks();
            }
        };
    }
}

