/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.dmr.ModelNode;

public class ServerGroupRemoveHandler
extends AbstractRemoveStepHandler {
    private final LocalHostControllerInfo hostControllerInfo;

    public ServerGroupRemoveHandler(LocalHostControllerInfo hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performRemove(context, operation, model);
        if (this.hostControllerInfo != null) {
            final String serverGroup = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            ModelNode validate = new ModelNode();
            validate.get("operation").set("validate");
            validate.get("address").add("host", this.hostControllerInfo.getLocalHostName());
            context.addStep(validate, new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    Resource host = context.readResource(PathAddress.EMPTY_ADDRESS, false);
                    Set entries = host.getChildren("server-config");
                    HashSet<String> foundServer = new HashSet<String>();
                    if (entries != null && !entries.isEmpty()) {
                        for (Resource.ResourceEntry entry : entries) {
                            Resource server = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{entry.getPathElement()}), false);
                            String group = server.getModel().require("group").asString();
                            if (!group.equals(serverGroup)) continue;
                            foundServer.add(entry.getName());
                        }
                    }
                    if (!foundServer.isEmpty()) {
                        throw DomainControllerMessages.MESSAGES.cannotRemoveUsedServerGroup(serverGroup, foundServer);
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.VERIFY);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }
}

