/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.PredicateIndex;
import org.infinispan.objectfilter.impl.predicateindex.be.BETree;
import org.infinispan.objectfilter.impl.predicateindex.be.BETreeMaker;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.util.StringHelper;

public final class FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>> {
    private final PredicateIndex<AttributeMetadata, AttributeId> predicateIndex;
    private final List<FilterSubscriptionImpl> filterSubscriptions = new ArrayList<FilterSubscriptionImpl>();
    private final BETreeMaker<AttributeId> treeMaker;
    private final MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter;
    private final boolean useIntervals;

    public FilterRegistry(MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter, boolean useIntervals) {
        this.metadataAdapter = metadataAdapter;
        this.useIntervals = useIntervals;
        this.treeMaker = new BETreeMaker<AttributeId>(metadataAdapter, useIntervals);
        this.predicateIndex = new PredicateIndex<AttributeMetadata, AttributeId>(metadataAdapter);
    }

    public MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> getMetadataAdapter() {
        return this.metadataAdapter;
    }

    public PredicateIndex<AttributeMetadata, AttributeId> getPredicateIndex() {
        return this.predicateIndex;
    }

    public int getNumFilters() {
        return this.filterSubscriptions.size();
    }

    public void match(MatcherEvalContext<?, AttributeMetadata, AttributeId> ctx) {
        ctx.process(this.predicateIndex.getRoot());
        for (FilterSubscriptionImpl s : this.filterSubscriptions) {
            FilterEvalContext filterEvalContext = ctx.getFilterEvalContext(s);
            if (!filterEvalContext.getMatchResult()) continue;
            s.getCallback().onFilterResult(ctx.getUserContext(), ctx.getInstance(), ctx.getEventType(), filterEvalContext.getProjection(), filterEvalContext.getSortProjection());
        }
    }

    public FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> addFilter(String queryString, BooleanExpr normalizedFilter, List<String> projection, List<SortField> sortFields, FilterCallback callback, Object[] eventTypes) {
        if (eventTypes != null) {
            if (eventTypes.length == 0) {
                eventTypes = null;
            } else {
                for (Object et : eventTypes) {
                    if (et != null) continue;
                    eventTypes = null;
                    break;
                }
            }
        }
        ArrayList translatedProjections = null;
        if (projection != null && !projection.isEmpty()) {
            translatedProjections = new ArrayList(projection.size());
            for (String projectionPath : projection) {
                translatedProjections.add(this.metadataAdapter.translatePropertyPath(StringHelper.splitPropertyPath(projectionPath)));
            }
        }
        ArrayList translatedSortFields = null;
        if (sortFields != null && !sortFields.isEmpty()) {
            translatedSortFields = new ArrayList(sortFields.size());
            for (SortField sortField : sortFields) {
                translatedSortFields.add(this.metadataAdapter.translatePropertyPath(StringHelper.splitPropertyPath(sortField.getPath())));
            }
        }
        BETree beTree = this.treeMaker.make(normalizedFilter);
        FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> filterSubscription = new FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId>(queryString, this.useIntervals, this.metadataAdapter, beTree, callback, projection, translatedProjections, sortFields, translatedSortFields, eventTypes);
        filterSubscription.registerProjection(this.predicateIndex);
        filterSubscription.subscribe(this.predicateIndex);
        filterSubscription.index = this.filterSubscriptions.size();
        this.filterSubscriptions.add(filterSubscription);
        return filterSubscription;
    }

    public void removeFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        filterSubscriptionImpl.unregisterProjection(this.predicateIndex);
        filterSubscriptionImpl.unsubscribe(this.predicateIndex);
        this.filterSubscriptions.remove(filterSubscriptionImpl);
        for (int i = filterSubscriptionImpl.index; i < this.filterSubscriptions.size(); ++i) {
            --this.filterSubscriptions.get((int)i).index;
        }
        filterSubscriptionImpl.index = -1;
    }
}

