/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanOperatorExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NoOpVisitor;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class BooleanFilterNormalizer {
    private final Visitor simplifierVisitor = new NoOpVisitor(){

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            return (BooleanExpr)notExpr.getChild().acceptVisitor(BooleanFilterNormalizer.this.deMorganVisitor);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr child : orExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (child instanceof OrExpr) {
                    children.addAll(((OrExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            this.removeRedundantPredicates(children, false);
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new OrExpr(children);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr child : andExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (child instanceof AndExpr) {
                    children.addAll(((AndExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            this.removeRedundantPredicates(children, true);
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new AndExpr(children);
        }

        private void removeRedundantPredicates(List<BooleanExpr> children, boolean isConjunction) {
            for (int i = 0; i < children.size(); ++i) {
                BooleanExpr ci = children.get(i);
                if (ci instanceof BooleanOperatorExpr) continue;
                boolean isCiNegated = ci instanceof NotExpr;
                if (isCiNegated) {
                    ci = ((NotExpr)ci).getChild();
                }
                assert (ci instanceof PrimaryPredicateExpr);
                int j = i + 1;
                while (j < children.size()) {
                    BooleanExpr cj = children.get(j);
                    if (!(cj instanceof BooleanOperatorExpr)) {
                        int res;
                        boolean isCjNegated = cj instanceof NotExpr;
                        if (isCjNegated) {
                            cj = ((NotExpr)cj).getChild();
                        }
                        if ((res = this.comparePrimaryPredicateExpr(isCiNegated, (PrimaryPredicateExpr)ci, isCjNegated, (PrimaryPredicateExpr)cj)) == 0) {
                            children.remove(j);
                            continue;
                        }
                        if (res == 1) {
                            children.clear();
                            children.add(ConstantBooleanExpr.forBoolean(!isConjunction));
                            return;
                        }
                    }
                    ++j;
                }
            }
        }

        private int comparePrimaryPredicateExpr(boolean isFirstNegated, PrimaryPredicateExpr first, boolean isSecondNegated, PrimaryPredicateExpr second) {
            if (first.getClass() == second.getClass()) {
                if (first instanceof ComparisonExpr) {
                    ComparisonExpr comparison1 = (ComparisonExpr)first;
                    ComparisonExpr comparison2 = (ComparisonExpr)second;
                    assert (comparison1.getLeftChild() instanceof PropertyValueExpr);
                    assert (comparison2.getLeftChild() instanceof PropertyValueExpr);
                    if (comparison1.getLeftChild().equals(comparison2.getLeftChild()) && comparison1.getRightChild().equals(comparison2.getRightChild())) {
                        ComparisonExpr.Type cmpType1 = comparison1.getComparisonType();
                        if (isFirstNegated) {
                            cmpType1 = cmpType1.negate();
                        }
                        ComparisonExpr.Type cmpType2 = comparison2.getComparisonType();
                        if (isSecondNegated) {
                            cmpType2 = cmpType2.negate();
                        }
                        return cmpType1 == cmpType2 ? 0 : (cmpType1 == cmpType2.negate() ? 1 : -1);
                    }
                } else if (first.equals(second)) {
                    return isFirstNegated == isSecondNegated ? 0 : 1;
                }
            }
            return -1;
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            ValueExpr leftChild = comparisonExpr.getLeftChild();
            leftChild = (ValueExpr)leftChild.acceptVisitor(this);
            ValueExpr rightChild = comparisonExpr.getRightChild();
            rightChild = (ValueExpr)rightChild.acceptVisitor(this);
            ComparisonExpr.Type comparisonType = comparisonExpr.getComparisonType();
            if (leftChild instanceof ConstantValueExpr) {
                if (rightChild instanceof ConstantValueExpr) {
                    Comparable leftValue = ((ConstantValueExpr)leftChild).getConstantValue();
                    Comparable rightValue = ((ConstantValueExpr)rightChild).getConstantValue();
                    int compRes = leftValue.compareTo(rightValue);
                    switch (comparisonType) {
                        case LESS: {
                            return ConstantBooleanExpr.forBoolean(compRes < 0);
                        }
                        case LESS_OR_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes <= 0);
                        }
                        case EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes == 0);
                        }
                        case NOT_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes != 0);
                        }
                        case GREATER_OR_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes >= 0);
                        }
                        case GREATER: {
                            return ConstantBooleanExpr.forBoolean(compRes > 0);
                        }
                    }
                    throw new IllegalStateException("Unexpected comparison type: " + (Object)((Object)comparisonType));
                }
                ValueExpr temp = rightChild;
                rightChild = leftChild;
                leftChild = temp;
                comparisonType = comparisonType.reverse();
            }
            return new ComparisonExpr(leftChild, rightChild, comparisonType);
        }
    };
    private final Visitor deMorganVisitor = new NoOpVisitor(){

        @Override
        public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
            return constantBooleanExpr.negate();
        }

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            return (BooleanExpr)notExpr.getChild().acceptVisitor(BooleanFilterNormalizer.this.simplifierVisitor);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr child : orExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (child instanceof AndExpr) {
                    children.addAll(((AndExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new AndExpr(children);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr child : andExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (child instanceof OrExpr) {
                    children.addAll(((OrExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new OrExpr(children);
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            BooleanExpr booleanExpr = comparisonExpr.acceptVisitor(BooleanFilterNormalizer.this.simplifierVisitor);
            if (booleanExpr instanceof ConstantBooleanExpr) {
                return ((ConstantBooleanExpr)booleanExpr).negate();
            }
            if (booleanExpr instanceof NotExpr) {
                return ((NotExpr)booleanExpr).getChild();
            }
            if (booleanExpr instanceof ComparisonExpr) {
                ComparisonExpr c = (ComparisonExpr)booleanExpr;
                switch (c.getComparisonType()) {
                    case LESS: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonExpr.Type.GREATER_OR_EQUAL);
                    }
                    case LESS_OR_EQUAL: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonExpr.Type.GREATER);
                    }
                    case GREATER_OR_EQUAL: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonExpr.Type.LESS);
                    }
                    case GREATER: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonExpr.Type.LESS_OR_EQUAL);
                    }
                    case EQUAL: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonExpr.Type.NOT_EQUAL);
                    }
                    case NOT_EQUAL: {
                        return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), ComparisonExpr.Type.EQUAL);
                    }
                }
                throw new IllegalStateException("Unexpected comparison type: " + (Object)((Object)c.getComparisonType()));
            }
            return new NotExpr(booleanExpr);
        }

        @Override
        public BooleanExpr visit(IsNullExpr isNullExpr) {
            return new NotExpr(isNullExpr);
        }

        @Override
        public BooleanExpr visit(LikeExpr likeExpr) {
            return new NotExpr(likeExpr);
        }
    };

    public BooleanExpr normalize(BooleanExpr booleanExpr) {
        return (BooleanExpr)booleanExpr.acceptVisitor(this.simplifierVisitor);
    }
}

