/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;

public abstract class AbstractConstrainedElement
implements ConstrainedElement {
    private final ConstrainedElement.ConstrainedElementKind kind;
    protected final ConfigurationSource source;
    protected final ConstraintLocation location;
    protected final Set<MetaConstraint<?>> constraints;
    protected final Map<Class<?>, Class<?>> groupConversions;
    protected final boolean isCascading;
    protected final boolean requiresUnwrapping;

    public AbstractConstrainedElement(ConfigurationSource source, ConstrainedElement.ConstrainedElementKind kind, ConstraintLocation location, Set<MetaConstraint<?>> constraints, Map<Class<?>, Class<?>> groupConversions, boolean isCascading, boolean requiresUnwrapping) {
        this.kind = kind;
        this.source = source;
        this.location = location;
        this.constraints = constraints != null ? Collections.unmodifiableSet(constraints) : Collections.emptySet();
        this.groupConversions = Collections.unmodifiableMap(groupConversions);
        this.isCascading = isCascading;
        this.requiresUnwrapping = requiresUnwrapping;
    }

    @Override
    public ConstrainedElement.ConstrainedElementKind getKind() {
        return this.kind;
    }

    @Override
    public ConstraintLocation getLocation() {
        return this.location;
    }

    @Override
    public Iterator<MetaConstraint<?>> iterator() {
        return this.constraints.iterator();
    }

    @Override
    public Set<MetaConstraint<?>> getConstraints() {
        return this.constraints;
    }

    @Override
    public Map<Class<?>, Class<?>> getGroupConversions() {
        return this.groupConversions;
    }

    @Override
    public boolean isCascading() {
        return this.isCascading;
    }

    @Override
    public boolean isConstrained() {
        return this.isCascading || !this.constraints.isEmpty();
    }

    @Override
    public boolean requiresUnwrapping() {
        return this.requiresUnwrapping;
    }

    public String toString() {
        return "AbstractConstrainedElement [kind=" + (Object)((Object)this.kind) + ", source=" + (Object)((Object)this.source) + ", location=" + this.location + ", constraints=" + this.constraints + ", groupConversions=" + this.groupConversions + ", isCascading=" + this.isCascading + ", requiresUnwrapping=" + this.requiresUnwrapping + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractConstrainedElement other = (AbstractConstrainedElement)obj;
        return this.source == other.source;
    }
}

