/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class BasicComponentCreateService
implements Service<Component> {
    private final InjectedValue<DeploymentUnit> deploymentUnit = new InjectedValue();
    private final ServiceName serviceName;
    private final String componentName;
    private final Class<?> componentClass;
    private final InterceptorFactory postConstruct;
    private final InterceptorFactory preDestroy;
    private final Map<Method, InterceptorFactory> componentInterceptors;
    private final NamespaceContextSelector namespaceContextSelector;
    private BasicComponent component;

    public BasicComponentCreateService(ComponentConfiguration componentConfiguration) {
        this.serviceName = componentConfiguration.getComponentDescription().getCreateServiceName();
        this.componentName = componentConfiguration.getComponentName();
        this.postConstruct = Interceptors.getChainedInterceptorFactory(componentConfiguration.getPostConstructInterceptors());
        this.preDestroy = Interceptors.getChainedInterceptorFactory(componentConfiguration.getPreDestroyInterceptors());
        IdentityHashMap<Method, InterceptorFactory> componentInterceptors = new IdentityHashMap<Method, InterceptorFactory>();
        for (Method method : componentConfiguration.getDefinedComponentMethods()) {
            if (!this.requiresInterceptors(method, componentConfiguration)) continue;
            componentInterceptors.put(method, Interceptors.getChainedInterceptorFactory(componentConfiguration.getComponentInterceptors(method)));
        }
        this.componentClass = componentConfiguration.getComponentClass();
        this.componentInterceptors = componentInterceptors;
        this.namespaceContextSelector = componentConfiguration.getNamespaceContextSelector();
    }

    protected boolean requiresInterceptors(Method method, ComponentConfiguration componentConfiguration) {
        return Modifier.isPublic(method.getModifiers()) && componentConfiguration.getComponentDescription().isIntercepted();
    }

    public synchronized void start(StartContext context) throws StartException {
        this.component = this.createComponent();
    }

    protected BasicComponent createComponent() {
        return new BasicComponent(this);
    }

    public synchronized void stop(StopContext context) {
        this.component = null;
    }

    public synchronized Component getValue() throws IllegalStateException, IllegalArgumentException {
        BasicComponent component = this.component;
        if (component == null) {
            throw EeMessages.MESSAGES.serviceNotStarted();
        }
        return component;
    }

    public InjectedValue<DeploymentUnit> getDeploymentUnitInjector() {
        return this.deploymentUnit;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public InterceptorFactory getPostConstruct() {
        return this.postConstruct;
    }

    public InterceptorFactory getPreDestroy() {
        return this.preDestroy;
    }

    public Map<Method, InterceptorFactory> getComponentInterceptors() {
        return this.componentInterceptors;
    }

    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public NamespaceContextSelector getNamespaceContextSelector() {
        return this.namespaceContextSelector;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }
}

