/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.value.Value;

final class ManagedReferenceFieldInjectionInterceptorFactory
implements InterceptorFactory {
    private final Object targetContextKey;
    private final Object valueContextKey;
    private final Value<ManagedReferenceFactory> factoryValue;
    private final Field field;
    private final boolean optional;

    ManagedReferenceFieldInjectionInterceptorFactory(Object targetContextKey, Object valueContextKey, Value<ManagedReferenceFactory> factoryValue, Field field, boolean optional) {
        this.targetContextKey = targetContextKey;
        this.valueContextKey = valueContextKey;
        this.factoryValue = factoryValue;
        this.field = field;
        this.optional = optional;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        return new ManagedReferenceFieldInjectionInterceptor(this.targetContextKey, this.valueContextKey, (ManagedReferenceFactory)this.factoryValue.getValue(), this.field, this.optional);
    }

    static final class ManagedReferenceFieldInjectionInterceptor
    implements Interceptor {
        private final Object targetKey;
        private final ManagedReferenceFactory factory;
        private final Field field;
        private final boolean optional;
        private final Object valueContextKey;

        ManagedReferenceFieldInjectionInterceptor(Object targetKey, Object valueContextKey, ManagedReferenceFactory factory, Field field, boolean optional) {
            this.targetKey = targetKey;
            this.factory = factory;
            this.field = field;
            this.optional = optional;
            this.valueContextKey = valueContextKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            Object target;
            ComponentInstance componentInstance = (ComponentInstance)context.getPrivateData(ComponentInstance.class);
            if (Modifier.isStatic(this.field.getModifiers())) {
                target = null;
            } else {
                target = ((ManagedReference)componentInstance.getInstanceData(this.targetKey)).getInstance();
                if (target == null) {
                    throw EeMessages.MESSAGES.injectionTargetNotFound();
                }
            }
            ManagedReference reference = this.factory.getReference();
            if (reference == null && this.optional) {
                return context.proceed();
            }
            if (reference == null) {
                throw EeMessages.MESSAGES.managedReferenceWasNull(this.field);
            }
            boolean ok = false;
            try {
                componentInstance.setInstanceData(this.valueContextKey, reference);
                this.field.set(target, reference.getInstance());
                Object result = context.proceed();
                ok = true;
                Object object = result;
                return object;
            }
            finally {
                if (!ok) {
                    componentInstance.setInstanceData(this.valueContextKey, null);
                    reference.release();
                }
            }
        }
    }
}

