/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.ee.subsystem.Attribute;
import org.jboss.as.ee.subsystem.ContextServiceResourceDefinition;
import org.jboss.as.ee.subsystem.DefaultBindingsResourceDefinition;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;
import org.jboss.as.ee.subsystem.Element;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.ee.subsystem.ManagedExecutorServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedScheduledExecutorServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedThreadFactoryResourceDefinition;
import org.jboss.as.ee.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class EESubsystemXmlPersister
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final EESubsystemXmlPersister INSTANCE = new EESubsystemXmlPersister();

    private EESubsystemXmlPersister() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.EE_2_0.getUriString(), false);
        ModelNode eeSubSystem = context.getModelNode();
        GlobalModulesDefinition.INSTANCE.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        EeSubsystemRootResource.SPEC_DESCRIPTOR_PROPERTY_REPLACEMENT.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        EeSubsystemRootResource.JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        EeSubsystemRootResource.ANNOTATION_PROPERTY_REPLACEMENT.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        this.writeConcurrentElement(writer, eeSubSystem);
        this.writeDefaultBindingsElement(writer, eeSubSystem);
        writer.writeEndElement();
    }

    private void writeConcurrentElement(XMLExtendedStreamWriter writer, ModelNode eeSubSystem) throws XMLStreamException {
        boolean started = false;
        if (eeSubSystem.hasDefined("context-service")) {
            writer.writeStartElement(Element.CONCURRENT.getLocalName());
            started = true;
            this.writeContextServices(writer, eeSubSystem.get("context-service"));
        }
        if (eeSubSystem.hasDefined("managed-thread-factory")) {
            if (!started) {
                writer.writeStartElement(Element.CONCURRENT.getLocalName());
                started = true;
            }
            this.writeManagedThreadFactories(writer, eeSubSystem.get("managed-thread-factory"));
        }
        if (eeSubSystem.hasDefined("managed-executor-service")) {
            if (!started) {
                writer.writeStartElement(Element.CONCURRENT.getLocalName());
                started = true;
            }
            this.writeManagedExecutorServices(writer, eeSubSystem.get("managed-executor-service"));
        }
        if (eeSubSystem.hasDefined("managed-scheduled-executor-service")) {
            if (!started) {
                writer.writeStartElement(Element.CONCURRENT.getLocalName());
                started = true;
            }
            this.writeManagedScheduledExecutorServices(writer, eeSubSystem.get("managed-scheduled-executor-service"));
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private void writeContextServices(XMLExtendedStreamWriter writer, ModelNode subModel) throws XMLStreamException {
        writer.writeStartElement(Element.CONTEXT_SERVICES.getLocalName());
        for (Property property : subModel.asPropertyList()) {
            writer.writeStartElement(Element.CONTEXT_SERVICE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            for (SimpleAttributeDefinition ad : ContextServiceResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeManagedThreadFactories(XMLExtendedStreamWriter writer, ModelNode subModel) throws XMLStreamException {
        writer.writeStartElement(Element.MANAGED_THREAD_FACTORIES.getLocalName());
        for (Property property : subModel.asPropertyList()) {
            writer.writeStartElement(Element.MANAGED_THREAD_FACTORY.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            for (SimpleAttributeDefinition ad : ManagedThreadFactoryResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeManagedExecutorServices(XMLExtendedStreamWriter writer, ModelNode subModel) throws XMLStreamException {
        writer.writeStartElement(Element.MANAGED_EXECUTOR_SERVICES.getLocalName());
        for (Property property : subModel.asPropertyList()) {
            writer.writeStartElement(Element.MANAGED_EXECUTOR_SERVICE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            for (SimpleAttributeDefinition ad : ManagedExecutorServiceResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeManagedScheduledExecutorServices(XMLExtendedStreamWriter writer, ModelNode subModel) throws XMLStreamException {
        writer.writeStartElement(Element.MANAGED_SCHEDULED_EXECUTOR_SERVICES.getLocalName());
        for (Property property : subModel.asPropertyList()) {
            writer.writeStartElement(Element.MANAGED_SCHEDULED_EXECUTOR_SERVICE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            for (SimpleAttributeDefinition ad : ManagedScheduledExecutorServiceResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeDefaultBindingsElement(XMLExtendedStreamWriter writer, ModelNode eeSubSystem) throws XMLStreamException {
        if (eeSubSystem.hasDefined("service") && eeSubSystem.get("service").hasDefined("default-bindings")) {
            ModelNode defaultBindingsNode = eeSubSystem.get(new String[]{"service", "default-bindings"});
            writer.writeStartElement(Element.DEFAULT_BINDINGS.getLocalName());
            for (SimpleAttributeDefinition ad : DefaultBindingsResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(defaultBindingsNode, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
    }
}

