/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class RelatedAuditExpression
implements AuditCriterion {
    private final PropertyNameGetter propertyNameGetter;
    private final Object id;
    private final boolean equals;

    public RelatedAuditExpression(PropertyNameGetter propertyNameGetter, Object id, boolean equals) {
        this.propertyNameGetter = propertyNameGetter;
        this.id = id;
        this.equals = equals;
    }

    @Override
    public void addToQuery(AuditConfiguration auditCfg, AuditReaderImplementor versionsReader, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(auditCfg, versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(auditCfg, entityName, propertyName);
        if (relatedEntity == null) {
            throw new AuditException("This criterion can only be used on a property that is a relation to another property.");
        }
        relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, this.id, null, this.equals);
    }
}

