/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.CommonLogger;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.v10.DataSource;
import org.jboss.jca.common.api.metadata.ds.v10.XaDataSource;
import org.jboss.jca.common.api.metadata.ds.v12.DsPool;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public abstract class AbstractParser {
    private static CommonLogger log = (CommonLogger)Logger.getMessageLogger(CommonLogger.class, (String)AbstractParser.class.getName());
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private boolean resolveSystemProperties = true;

    public boolean isSystemPropertiesResolved() {
        return this.resolveSystemProperties;
    }

    public void setSystemPropertiesResolved(boolean v) {
        this.resolveSystemProperties = v;
    }

    protected Boolean elementAsBoolean(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String elementtext = this.rawElementText(reader);
        String stringValue = this.getSubstitutionValue(elementtext);
        if (stringValue == null || stringValue.length() == 0 || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return stringValue == null || stringValue.length() == 0 ? Boolean.TRUE : Boolean.valueOf(stringValue.trim());
        }
        throw new ParserException(bundle.elementAsBoolean(elementtext, reader.getLocalName()));
    }

    protected Boolean attributeAsBoolean(XMLStreamReader reader, String attributeName, Boolean defaultValue) throws XMLStreamException, ParserException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        String stringValue = this.getSubstitutionValue(attributeString);
        if (stringValue == null || stringValue.length() == 0 || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return attributeString == null ? defaultValue : Boolean.valueOf(reader.getAttributeValue("", attributeName).trim());
        }
        throw new ParserException(bundle.attributeAsBoolean(attributeString, reader.getLocalName()));
    }

    protected String elementAsString(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = this.rawElementText(reader);
        return this.getSubstitutionValue(elementtext);
    }

    private String rawElementText(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = reader.getElementText();
        elementtext = elementtext == null ? null : elementtext.trim();
        return elementtext;
    }

    protected String attributeAsString(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        return this.getSubstitutionValue(attributeString);
    }

    protected Integer attributeAsInt(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        String attributeString = this.getSubstitutionValue(this.rawAttributeText(reader, attributeName));
        return attributeString != null ? Integer.valueOf(this.getSubstitutionValue(attributeString)) : null;
    }

    private String rawAttributeText(XMLStreamReader reader, String attributeName) {
        String attributeString = reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
        return attributeString;
    }

    protected Integer elementAsInteger(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Integer integerValue = null;
        String elementtext = this.rawElementText(reader);
        try {
            integerValue = Integer.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(bundle.notValidNumber(elementtext, reader.getLocalName()));
        }
        return integerValue;
    }

    protected Long elementAsLong(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Long longValue = null;
        String elementtext = this.rawElementText(reader);
        try {
            longValue = Long.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(bundle.notValidNumber(elementtext, reader.getLocalName()));
        }
        return longValue;
    }

    protected FlushStrategy elementAsFlushStrategy(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String elementtext = this.rawElementText(reader);
        FlushStrategy result = FlushStrategy.forName((String)this.getSubstitutionValue(elementtext));
        if (result != FlushStrategy.UNKNOWN) {
            return result;
        }
        throw new ParserException(bundle.notValidFlushStrategy(elementtext));
    }

    protected CommonPool parsePool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return new CommonPoolImpl(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy);
                    }
                    if (CommonPool.Tag.forName((String)reader.getLocalName()) != CommonPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            flushStrategy = this.elementAsFlushStrategy(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected CommonSecurity parseSecuritySettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String securityDomain = null;
        String securityDomainAndApplication = null;
        boolean application = Defaults.APPLICATION_MANAGED_SECURITY;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return new CommonSecurityImpl(securityDomain, securityDomainAndApplication, application);
                    }
                    if (CommonSecurity.Tag.forName((String)reader.getLocalName()) != CommonSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonSecurity.Tag.forName((String)reader.getLocalName())) {
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            securityDomainAndApplication = this.elementAsString(reader);
                            break block0;
                        }
                        case APPLICATION: {
                            application = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected CommonXaPool parseXaPool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Boolean interleaving = Defaults.INTERLEAVING;
        Boolean isSameRmOverride = Defaults.IS_SAME_RM_OVERRIDE;
        Boolean padXid = Defaults.PAD_XID;
        Boolean noTxSeparatePool = Defaults.NO_TX_SEPARATE_POOL;
        Boolean wrapXaDataSource = Defaults.WRAP_XA_RESOURCE;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return new CommonXaPoolImpl(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaDataSource, noTxSeparatePool);
                    }
                    if (CommonXaPool.Tag.forName((String)reader.getLocalName()) != CommonXaPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (CommonXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            interleaving = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            isSameRmOverride = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            noTxSeparatePool = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PAD_XID: {
                            padXid = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            wrapXaDataSource = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            flushStrategy = this.elementAsFlushStrategy(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private String getSubstitutionValue(String input) throws XMLStreamException {
        if (input == null || input.trim().equals("")) {
            return input;
        }
        if (!this.resolveSystemProperties) {
            return input;
        }
        while (input.indexOf("${") != -1) {
            int from = input.indexOf("${");
            int to = input.indexOf("}");
            int dv = input.indexOf(":", from + 2);
            if (dv != -1 && dv > to) {
                dv = -1;
            }
            String systemProperty = "";
            String defaultValue = "";
            String s = input.substring(from + 2, to);
            if (dv == -1) {
                systemProperty = "/".equals(s) ? File.separator : (":".equals(s) ? File.pathSeparator : SecurityActions.getSystemProperty(s));
            } else {
                s = input.substring(from + 2, dv);
                systemProperty = SecurityActions.getSystemProperty(s);
                defaultValue = input.substring(dv + 1, to);
            }
            String prefix = "";
            String postfix = "";
            if (from != 0) {
                prefix = input.substring(0, from);
            }
            if (to + 1 < input.length() - 1) {
                postfix = input.substring(to + 1);
            }
            if (systemProperty != null && !systemProperty.trim().equals("")) {
                input = prefix + systemProperty + postfix;
                continue;
            }
            if (defaultValue != null && !defaultValue.trim().equals("")) {
                input = prefix + defaultValue + postfix;
                continue;
            }
            input = prefix + postfix;
            log.debugf("System property %s not set", s);
        }
        return input;
    }

    protected Credential parseCredential(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String securityDomain = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return new CredentialImpl(userName, password, securityDomain);
                    }
                    if (Credential.Tag.forName((String)reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Credential.Tag.forName((String)reader.getLocalName())) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            break block0;
                        }
                        case USER_NAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Recovery parseRecovery(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Boolean noRecovery = null;
        Credential security = null;
        Extension plugin = null;
        block11: for (Recovery.Attribute attribute : Recovery.Attribute.values()) {
            switch (attribute) {
                case NO_RECOVERY: {
                    noRecovery = this.attributeAsBoolean(reader, attribute.getLocalName(), Boolean.FALSE);
                    continue block11;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.RECOVERY) {
                        return new Recovery(security, plugin, noRecovery);
                    }
                    if (Recovery.Tag.forName((String)reader.getLocalName()) != Recovery.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Recovery.Tag tag = Recovery.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case RECOVER_CREDENTIAL: {
                            security = this.parseCredential(reader);
                            break block3;
                        }
                        case RECOVER_PLUGIN: {
                            plugin = this.parseExtension(reader, tag.getLocalName());
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Extension parseExtension(XMLStreamReader reader, String enclosingTag) throws XMLStreamException, ParserException, ValidateException {
        String className = null;
        HashMap<String, String> properties = null;
        block10: for (Extension.Attribute attribute : Extension.Attribute.values()) {
            switch (attribute) {
                case CLASS_NAME: {
                    className = this.attributeAsString(reader, attribute.getLocalName());
                    continue block10;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (reader.getLocalName().equals(enclosingTag)) {
                        if (className == null) {
                            throw new ParserException(bundle.missingClassName(enclosingTag));
                        }
                        return new Extension(className, properties);
                    }
                    if (Extension.Tag.forName((String)reader.getLocalName()) != Extension.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Extension.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            if (properties == null) {
                                properties = new HashMap<String, String>();
                            }
                            this.parseConfigProperty(properties, reader);
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Capacity parseCapacity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Extension incrementer = null;
        Extension decrementer = null;
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (DsPool.Tag.forName((String)reader.getLocalName()) == DsPool.Tag.CAPACITY) {
                        return new Capacity(incrementer, decrementer);
                    }
                    if (Capacity.Tag.forName((String)reader.getLocalName()) != Capacity.Tag.UNKNOWN) continue block8;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Capacity.Tag tag = Capacity.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case INCREMENTER: {
                            incrementer = this.parseExtension(reader, tag.getLocalName());
                            continue block8;
                        }
                        case DECREMENTER: {
                            decrementer = this.parseExtension(reader, tag.getLocalName());
                            continue block8;
                        }
                    }
                    continue block8;
                }
            }
            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parseConfigProperty(Map<String, String> configProperties, XMLStreamReader reader) throws XMLStreamException, ParserException {
        String n = this.attributeAsString(reader, "name");
        if (n == null || n.trim().equals("")) {
            throw new ParserException(bundle.requiredAttributeMissing("name", reader.getLocalName()));
        }
        configProperties.put(n, this.elementAsString(reader));
    }

    private static class SecurityActions {
        private SecurityActions() {
        }

        static String getSystemProperty(final String name) {
            if (System.getSecurityManager() == null) {
                return System.getProperty(name);
            }
            return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(name);
                }
            });
        }
    }
}

