/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.config;

import java.util.HashMap;
import java.util.Map;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class Configuration {
    public static final String PROVIDER_MODULE = "jboss.as.jpa.providerModule";
    public static final String PROVIDER_MODULE_HIBERNATE4_3 = "org.hibernate";
    public static final String PROVIDER_MODULE_HIBERNATE4_1 = "org.hibernate:4.1";
    public static final String PROVIDER_MODULE_HIBERNATE_OGM = "org.hibernate:ogm";
    public static final String PROVIDER_MODULE_HIBERNATE3 = "org.hibernate:3";
    public static final String PROVIDER_MODULE_ECLIPSELINK = "org.eclipse.persistence";
    public static final String PROVIDER_MODULE_TOPLINK = "oracle.toplink";
    public static final String PROVIDER_MODULE_DATANUCLEUS = "org.datanucleus";
    public static final String PROVIDER_MODULE_DATANUCLEUS_GAE = "org.datanucleus:appengine";
    public static final String PROVIDER_MODULE_OPENJPA = "org.apache.openjpa";
    public static final String PROVIDER_MODULE_DEFAULT = "org.hibernate";
    public static final String PROVIDER_CLASS_HIBERNATE4_1 = "org.hibernate.ejb.HibernatePersistence";
    public static final String PROVIDER_CLASS_HIBERNATE = "org.hibernate.jpa.HibernatePersistenceProvider";
    public static final String PROVIDER_CLASS_HIBERNATE_OGM = "org.hibernate.ogm.jpa.HibernateOgmPersistence";
    public static final String PROVIDER_CLASS_TOPLINK_ESSENTIALS = "oracle.toplink.essentials.PersistenceProvider";
    public static final String PROVIDER_CLASS_TOPLINK = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    public static final String PROVIDER_CLASS_ECLIPSELINK = "org.eclipse.persistence.jpa.PersistenceProvider";
    public static final String PROVIDER_CLASS_DATANUCLEUS = "org.datanucleus.api.jpa.PersistenceProviderImpl";
    public static final String PROVIDER_CLASS_DATANUCLEUS_GAE = "org.datanucleus.store.appengine.jpa.DatastorePersistenceProvider";
    public static final String PROVIDER_CLASS_OPENJPA = "org.apache.openjpa.persistence.PersistenceProviderImpl";
    public static final String PROVIDER_CLASS_DEFAULT = "org.hibernate.jpa.HibernatePersistenceProvider";
    public static final String PROVIDER_MODULE_APPLICATION_SUPPLIED = "application";
    public static final String PROVIDER_MODULE_HIBERNATE3_BUNDLED = "hibernate3-bundled";
    public static final String ADAPTER_MODULE_HIBERNATE3 = "org.jboss.as.jpa.hibernate:3";
    public static final String ADAPTER_MODULE_OPENJPA = "org.jboss.as.jpa.openjpa";
    public static final String ADAPTER_MODULE = "jboss.as.jpa.adapterModule";
    public static final String JPA_CONTAINER_MANAGED = "jboss.as.jpa.managed";
    public static final String JPA_DEFAULT_PERSISTENCE_UNIT = "wildfly.jpa.default-unit";
    public static final String JPA_CONTAINER_CLASS_TRANSFORMER = "jboss.as.jpa.classtransformer";
    public static final String JPA_ALLOW_TWO_PHASE_BOOTSTRAP = "wildfly.jpa.twophasebootstrap";
    private static final String JPA_ALLOW_DEFAULT_DATA_SOURCE_USE = "wildfly.jpa.allowdefaultdatasourceuse";
    public static final String ADAPTER_CLASS = "jboss.as.jpa.adapterClass";
    private static final Map<String, String> providerClassToModuleName = new HashMap<String, String>();
    private static final Map<String, String> providerClassToAdapterModuleName;

    public static String getProviderModuleNameFromProviderClassName(String providerClassName) {
        return providerClassToModuleName.get(providerClassName);
    }

    public static boolean needClassFileTransformer(PersistenceUnitMetadata pu) {
        boolean result = true;
        String provider = pu.getPersistenceProviderClassName();
        if (pu.getProperties().containsKey(JPA_CONTAINER_CLASS_TRANSFORMER)) {
            result = Boolean.parseBoolean(pu.getProperties().getProperty(JPA_CONTAINER_CLASS_TRANSFORMER));
        } else if (provider == null || provider.equals("org.hibernate.jpa.HibernatePersistenceProvider")) {
            String useHibernateClassEnhancer = pu.getProperties().getProperty("hibernate.ejb.use_class_enhancer");
            result = "true".equals(useHibernateClassEnhancer);
        }
        return result;
    }

    public static String getProviderAdapterModuleNameFromProviderClassName(String providerClassName) {
        return providerClassToAdapterModuleName.get(providerClassName);
    }

    public static String getDefaultProviderModuleName() {
        return "org.hibernate";
    }

    public static boolean allowTwoPhaseBootstrap(PersistenceUnitMetadata pu) {
        boolean result = true;
        if (pu.getProperties().containsKey(JPA_ALLOW_TWO_PHASE_BOOTSTRAP)) {
            result = Boolean.parseBoolean(pu.getProperties().getProperty(JPA_ALLOW_TWO_PHASE_BOOTSTRAP));
        }
        return result;
    }

    public static boolean allowDefaultDataSourceUse(PersistenceUnitMetadata pu) {
        boolean result = true;
        if (pu.getProperties().containsKey(JPA_ALLOW_DEFAULT_DATA_SOURCE_USE)) {
            result = Boolean.parseBoolean(pu.getProperties().getProperty(JPA_ALLOW_DEFAULT_DATA_SOURCE_USE));
        }
        return result;
    }

    static {
        providerClassToModuleName.put("org.hibernate.jpa.HibernatePersistenceProvider", "org.hibernate");
        providerClassToModuleName.put(PROVIDER_CLASS_HIBERNATE4_1, "org.hibernate");
        providerClassToModuleName.put(PROVIDER_CLASS_HIBERNATE_OGM, PROVIDER_MODULE_HIBERNATE_OGM);
        providerClassToModuleName.put(PROVIDER_CLASS_TOPLINK_ESSENTIALS, PROVIDER_MODULE_TOPLINK);
        providerClassToModuleName.put(PROVIDER_CLASS_TOPLINK, PROVIDER_MODULE_TOPLINK);
        providerClassToModuleName.put(PROVIDER_CLASS_ECLIPSELINK, PROVIDER_MODULE_ECLIPSELINK);
        providerClassToModuleName.put(PROVIDER_CLASS_DATANUCLEUS, PROVIDER_MODULE_DATANUCLEUS);
        providerClassToModuleName.put(PROVIDER_CLASS_DATANUCLEUS_GAE, PROVIDER_MODULE_DATANUCLEUS_GAE);
        providerClassToModuleName.put(PROVIDER_CLASS_OPENJPA, PROVIDER_MODULE_OPENJPA);
        providerClassToAdapterModuleName = new HashMap<String, String>();
        providerClassToAdapterModuleName.put(PROVIDER_CLASS_OPENJPA, ADAPTER_MODULE_OPENJPA);
    }
}

