/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.config;

import java.io.File;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.webservices.WSMessages;
import org.jboss.msc.value.InjectedValue;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.ws.common.management.AbstractServerConfigMBean;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;
import org.jboss.wsf.spi.metadata.config.ClientConfig;

public final class ServerConfigImpl
extends AbstractServerConfig
implements AbstractServerConfigMBean {
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final AtomicInteger wsDeploymentCount = new AtomicInteger(0);
    private final DMRSynchCheckHandler webServiceHostUCH = new DMRSynchCheckHandler();
    private final DMRSynchCheckHandler webServicePortUCH = new DMRSynchCheckHandler();
    private final DMRSynchCheckHandler webServiceSecurePortUCH = new DMRSynchCheckHandler();
    private final DMRSynchCheckHandler modifySOAPAddressUCH = new DMRSynchCheckHandler();

    private ServerConfigImpl() {
    }

    public void create() throws Exception {
        super.create();
        this.wsDeploymentCount.set(0);
        this.webServiceHostUCH.reset();
        this.webServicePortUCH.reset();
        this.webServiceSecurePortUCH.reset();
        this.modifySOAPAddressUCH.reset();
    }

    public void incrementWSDeploymentCount() {
        this.wsDeploymentCount.incrementAndGet();
    }

    public void decrementWSDeploymentCount() {
        this.wsDeploymentCount.decrementAndGet();
    }

    protected boolean isModifiable() {
        return this.wsDeploymentCount.get() == 0;
    }

    public void setWebServiceHost(String host, boolean forceUpdate) throws UnknownHostException {
        this.setWebServiceHost(host, forceUpdate ? null : this.webServiceHostUCH);
    }

    public void setWebServiceHost(String host) throws UnknownHostException {
        this.setWebServiceHost(host, this.webServiceHostUCH);
    }

    public void setWebServicePort(int port, boolean forceUpdate) {
        this.setWebServicePort(port, forceUpdate ? null : this.webServicePortUCH);
    }

    public void setWebServicePort(int port) {
        this.setWebServicePort(port, this.webServicePortUCH);
    }

    public void setWebServiceSecurePort(int port, boolean forceUpdate) {
        this.setWebServiceSecurePort(port, forceUpdate ? null : this.webServiceSecurePortUCH);
    }

    public void setWebServiceSecurePort(int port) {
        this.setWebServiceSecurePort(port, this.webServiceSecurePortUCH);
    }

    public void setModifySOAPAddress(boolean flag, boolean forceUpdate) {
        this.setModifySOAPAddress(flag, forceUpdate ? null : this.modifySOAPAddressUCH);
    }

    public void setModifySOAPAddress(boolean flag) {
        this.setModifySOAPAddress(flag, this.modifySOAPAddressUCH);
    }

    public File getServerTempDir() {
        return this.getServerEnvironment().getServerTempDir();
    }

    public File getHomeDir() {
        return this.getServerEnvironment().getHomeDir();
    }

    public File getServerDataDir() {
        return this.getServerEnvironment().getServerDataDir();
    }

    public MBeanServer getMbeanServer() {
        return (MBeanServer)this.injectedMBeanServer.getValue();
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        throw new UnsupportedOperationException();
    }

    public InjectedValue<MBeanServer> getMBeanServerInjector() {
        return this.injectedMBeanServer;
    }

    public InjectedValue<ServerEnvironment> getServerEnvironmentInjector() {
        return this.injectedServerEnvironment;
    }

    private ServerEnvironment getServerEnvironment() {
        return (ServerEnvironment)this.injectedServerEnvironment.getValue();
    }

    public static ServerConfigImpl newInstance() {
        return new ServerConfigImpl();
    }

    public void setClientConfigWrapper(ClientConfig config, boolean reload) {
        this.clientConfigStore.setWrapperConfig((AbstractCommonConfig)config, reload);
    }

    private class DMRSynchCheckHandler
    implements AbstractServerConfig.UpdateCallbackHandler {
        private volatile boolean dmrSynched = true;

        private DMRSynchCheckHandler() {
        }

        public void onBeforeUpdate() {
            if (!this.dmrSynched) {
                throw WSMessages.MESSAGES.couldNotUpdateServerConfigBecauseOfReloadRequired();
            }
            if (!ServerConfigImpl.this.isModifiable()) {
                this.dmrSynched = false;
                throw WSMessages.MESSAGES.couldNotUpdateServerConfigBecauseOfExistingWSDeployment();
            }
        }

        public void reset() {
            this.dmrSynched = true;
        }
    }
}

