/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.ClientConfigAdd;
import org.jboss.as.webservices.dmr.EndpointConfigAdd;
import org.jboss.as.webservices.dmr.HandlerAdd;
import org.jboss.as.webservices.dmr.HandlerChainAdd;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.as.webservices.dmr.PropertyAdd;
import org.jboss.as.webservices.dmr.WSEndpointMetrics;
import org.jboss.as.webservices.dmr.WSServerConfigAttributeHandler;
import org.jboss.as.webservices.dmr.WSSubsystemAdd;
import org.jboss.as.webservices.dmr.WSSubsystemLegacyReader;
import org.jboss.as.webservices.dmr.WSSubsystemReader;
import org.jboss.as.webservices.dmr.WSSubsystemRemove;
import org.jboss.as.webservices.dmr.WSSubsystemWriter;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public final class WSExtension
implements Extension {
    static final PathElement ENDPOINT_PATH = PathElement.pathElement((String)"endpoint");
    static final PathElement CLIENT_CONFIG_PATH = PathElement.pathElement((String)"client-config");
    static final PathElement ENDPOINT_CONFIG_PATH = PathElement.pathElement((String)"endpoint-config");
    private static final PathElement PROPERTY_PATH = PathElement.pathElement((String)"property");
    static final PathElement PRE_HANDLER_CHAIN_PATH = PathElement.pathElement((String)"pre-handler-chain");
    static final PathElement POST_HANDLER_CHAIN_PATH = PathElement.pathElement((String)"post-handler-chain");
    static final PathElement HANDLER_PATH = PathElement.pathElement((String)"handler");
    public static final String SUBSYSTEM_NAME = "webservices";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"webservices");
    private static final String RESOURCE_NAME = WSExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    static final AttributeDefinition ENDPOINT_WSDL = new SimpleAttributeDefinitionBuilder("wsdl-url", ModelType.STRING, false).setStorageRuntime().build();
    static final AttributeDefinition ENDPOINT_CLASS = new SimpleAttributeDefinitionBuilder("class", ModelType.STRING, false).setStorageRuntime().build();
    static final AttributeDefinition ENDPOINT_CONTEXT = new SimpleAttributeDefinitionBuilder("context", ModelType.STRING, false).setStorageRuntime().build();
    static final AttributeDefinition ENDPOINT_TYPE = new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setStorageRuntime().build();
    static final AttributeDefinition ENDPOINT_NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setStorageRuntime().build();

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, WSExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        subsystem.registerXMLElementWriter((XMLElementWriter)WSSubsystemWriter.getInstance());
        ResourceBuilder propertyResource = ResourceBuilder.Factory.create((PathElement)PROPERTY_PATH, (StandardResourceDescriptionResolver)WSExtension.getResourceDescriptionResolver("property")).setAddOperation((AbstractAddStepHandler)PropertyAdd.INSTANCE).setRemoveOperation((AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).addReadWriteAttribute((AttributeDefinition)Attributes.VALUE, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{Attributes.VALUE}));
        ResourceBuilder handlerBuilder = ResourceBuilder.Factory.create((PathElement)HANDLER_PATH, (StandardResourceDescriptionResolver)WSExtension.getResourceDescriptionResolver("handler")).setAddOperation((AbstractAddStepHandler)HandlerAdd.INSTANCE).setRemoveOperation((AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).addReadWriteAttribute((AttributeDefinition)Attributes.CLASS, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{Attributes.CLASS}));
        ResourceBuilder preHandler = ResourceBuilder.Factory.create((PathElement)PRE_HANDLER_CHAIN_PATH, (StandardResourceDescriptionResolver)WSExtension.getResourceDescriptionResolver("pre-handler-chain")).setAddOperation((AbstractAddStepHandler)HandlerChainAdd.INSTANCE).setRemoveOperation((AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).addReadWriteAttribute((AttributeDefinition)Attributes.PROTOCOL_BINDINGS, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{Attributes.PROTOCOL_BINDINGS})).pushChild(handlerBuilder).pop();
        ResourceBuilder postHandler = ResourceBuilder.Factory.create((PathElement)POST_HANDLER_CHAIN_PATH, (StandardResourceDescriptionResolver)WSExtension.getResourceDescriptionResolver("post-handler-chain")).setAddOperation((AbstractAddStepHandler)HandlerChainAdd.INSTANCE).setRemoveOperation((AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).addReadWriteAttribute((AttributeDefinition)Attributes.PROTOCOL_BINDINGS, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{Attributes.PROTOCOL_BINDINGS})).pushChild(handlerBuilder).pop();
        ResourceDefinition epConfigsDef = ResourceBuilder.Factory.create((PathElement)ENDPOINT_CONFIG_PATH, (StandardResourceDescriptionResolver)WSExtension.getResourceDescriptionResolver("endpoint-config")).setAddOperation((AbstractAddStepHandler)EndpointConfigAdd.INSTANCE).setRemoveOperation((AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).pushChild(propertyResource).pop().pushChild(preHandler).pop().pushChild(postHandler).pop().build();
        ResourceDefinition clConfigsDef = ResourceBuilder.Factory.create((PathElement)CLIENT_CONFIG_PATH, (StandardResourceDescriptionResolver)WSExtension.getResourceDescriptionResolver("client-config")).setAddOperation((AbstractAddStepHandler)ClientConfigAdd.INSTANCE).setRemoveOperation((AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).pushChild(propertyResource).pop().pushChild(preHandler).pop().pushChild(postHandler).pop().build();
        ResourceDefinition subsystemResource = ResourceBuilder.Factory.createSubsystemRoot((PathElement)SUBSYSTEM_PATH, (StandardResourceDescriptionResolver)WSExtension.getResourceDescriptionResolver(new String[0]), (OperationStepHandler)WSSubsystemAdd.INSTANCE, (OperationStepHandler)WSSubsystemRemove.INSTANCE).addReadWriteAttribute((AttributeDefinition)Attributes.WSDL_HOST, null, (OperationStepHandler)new WSServerConfigAttributeHandler(new AttributeDefinition[]{Attributes.WSDL_HOST})).addReadWriteAttribute((AttributeDefinition)Attributes.WSDL_PORT, null, (OperationStepHandler)new WSServerConfigAttributeHandler(new AttributeDefinition[]{Attributes.WSDL_PORT})).addReadWriteAttribute((AttributeDefinition)Attributes.WSDL_SECURE_PORT, null, (OperationStepHandler)new WSServerConfigAttributeHandler(new AttributeDefinition[]{Attributes.WSDL_SECURE_PORT})).addReadWriteAttribute((AttributeDefinition)Attributes.MODIFY_WSDL_ADDRESS, null, (OperationStepHandler)new WSServerConfigAttributeHandler(new AttributeDefinition[]{Attributes.MODIFY_WSDL_ADDRESS})).build();
        ManagementResourceRegistration subsystemRegistration = subsystem.registerSubsystemModel(subsystemResource);
        subsystemRegistration.registerSubModel(epConfigsDef);
        subsystemRegistration.registerSubModel(clConfigsDef);
        if (registerRuntimeOnly) {
            subsystem.registerDeploymentModel(ResourceBuilder.Factory.create((PathElement)SUBSYSTEM_PATH, (StandardResourceDescriptionResolver)WSExtension.getResourceDescriptionResolver("deployment")).pushChild(ENDPOINT_PATH).addMetrics((OperationStepHandler)WSEndpointMetrics.INSTANCE, WSEndpointMetrics.ATTRIBUTES).addReadOnlyAttribute(ENDPOINT_CLASS).addReadOnlyAttribute(ENDPOINT_CONTEXT).addReadOnlyAttribute(ENDPOINT_NAME).addReadOnlyAttribute(ENDPOINT_TYPE).addReadOnlyAttribute(ENDPOINT_WSDL).build());
        }
        if (context.isRegisterTransformers()) {
            this.registerTransformers1_1_0(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEBSERVICES_1_0.getUriString(), (XMLElementReader)WSSubsystemLegacyReader.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEBSERVICES_1_1.getUriString(), (XMLElementReader)WSSubsystemReader.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEBSERVICES_1_2.getUriString(), (XMLElementReader)WSSubsystemReader.getInstance());
    }

    private void registerTransformers1_1_0(SubsystemRegistration registration) {
        ModelVersion version = ModelVersion.create((int)1, (int)1, (int)0);
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])Attributes.SUBSYSTEM_ATTRIBUTES)).end();
        builder.rejectChildResource(CLIENT_CONFIG_PATH);
        ResourceTransformationDescriptionBuilder endpoint = builder.addChildResource(ENDPOINT_CONFIG_PATH);
        ((AttributeTransformationDescriptionBuilder)endpoint.addChildResource(PRE_HANDLER_CHAIN_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Attributes.PROTOCOL_BINDINGS})).end();
        ((AttributeTransformationDescriptionBuilder)endpoint.addChildResource(POST_HANDLER_CHAIN_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Attributes.PROTOCOL_BINDINGS})).end();
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)registration, (ModelVersionRange)version);
    }
}

