/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import java.util.Properties;
import org.hibernate.search.impl.DefaultMassIndexerFactory;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.MassIndexerFactory;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class MassIndexerFactoryProvider
implements ServiceProvider<MassIndexerFactory> {
    public static final String MASS_INDEXER_FACTORY_CLASSNAME = "hibernate.search.massindexer.factoryclass";
    private volatile MassIndexerFactory massIndexerFactory;

    private MassIndexerFactory createFactory(String factoryClassName) {
        if (factoryClassName == null) {
            return new DefaultMassIndexerFactory();
        }
        return this.customFactory(factoryClassName);
    }

    private MassIndexerFactory customFactory(String factoryClassName) {
        return (MassIndexerFactory)ClassLoaderHelper.instanceFromName(MassIndexerFactory.class, (String)factoryClassName, (ClassLoader)this.getClass().getClassLoader(), (String)"Mass indexer factory");
    }

    public void start(Properties properties, BuildContext context) {
        String factoryClassName = properties.getProperty(MASS_INDEXER_FACTORY_CLASSNAME);
        this.massIndexerFactory = this.createFactory(factoryClassName);
        this.massIndexerFactory.initialize(properties);
    }

    public MassIndexerFactory getService() {
        return this.massIndexerFactory;
    }

    public void stop() {
    }
}

