/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.HashMap;
import java.util.Map;

public enum Namespace {
    UNKNOWN(null),
    NONE(null),
    XML_SCHEMA_INSTANCE("http://www.w3.org/2001/XMLSchema-instance"),
    CLI_1_0("urn:jboss:cli:1.0"),
    CLI_1_1("urn:jboss:cli:1.1"),
    CLI_1_2("urn:jboss:cli:1.2"),
    CLI_2_0("urn:jboss:cli:2.0");

    public static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        if (uri == null || "".equals(uri)) {
            return NONE;
        }
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    public static Namespace[] cliValues() {
        Namespace[] temp = Namespace.values();
        Namespace[] response = new Namespace[temp.length - 3];
        int nextPos = 0;
        for (Namespace current : temp) {
            if (current == UNKNOWN || current == NONE || current == XML_SCHEMA_INSTANCE) continue;
            response[nextPos++] = current;
        }
        return response;
    }

    static {
        CURRENT = CLI_2_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

