/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.as.webservices.service.EndpointPublishService;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.as.xts.CDIExtensionProcessor;
import org.jboss.as.xts.TxBridgeInboundRecoveryService;
import org.jboss.as.xts.TxBridgeOutboundRecoveryService;
import org.jboss.as.xts.XTSDependenciesDeploymentProcessor;
import org.jboss.as.xts.XTSHandlerDeploymentProcessor;
import org.jboss.as.xts.XTSHandlersService;
import org.jboss.as.xts.XTSInterceptorDeploymentProcessor;
import org.jboss.as.xts.XTSManagerService;
import org.jboss.as.xts.XTSServices;
import org.jboss.as.xts.XTSSubsystemDefinition;
import org.jboss.as.xts.XtsAsLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.jbossts.XTSService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.management.ServerConfig;

class XTSSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final XTSSubsystemAdd INSTANCE = new XTSSubsystemAdd();
    private static final String[] WAR_DEPLOYMENT_NAMES = new String[]{"ws-c11.war", "ws-t11-coordinator.war", "ws-t11-participant.war", "ws-t11-client.war"};
    private static final ContextInfo[] contextDefinitions = new ContextInfo[]{new ContextInfo("ws-c11", new EndpointInfo[]{new EndpointInfo("com.arjuna.webservices11.wscoor.sei.ActivationPortTypeImpl", "ActivationService"), new EndpointInfo("com.arjuna.webservices11.wscoor.sei.RegistrationPortTypeImpl", "RegistrationService")}), new ContextInfo("ws-t11-coordinator", new EndpointInfo[]{new EndpointInfo("com.arjuna.webservices11.wsat.sei.CoordinatorPortTypeImpl", "CoordinatorService"), new EndpointInfo("com.arjuna.webservices11.wsat.sei.CompletionCoordinatorPortTypeImpl", "CompletionCoordinatorService"), new EndpointInfo("com.arjuna.webservices11.wsat.sei.CompletionCoordinatorRPCPortTypeImpl", "CompletionCoordinatorRPCService"), new EndpointInfo("com.arjuna.webservices11.wsba.sei.BusinessAgreementWithCoordinatorCompletionCoordinatorPortTypeImpl", "BusinessAgreementWithCoordinatorCompletionCoordinatorService"), new EndpointInfo("com.arjuna.webservices11.wsba.sei.BusinessAgreementWithParticipantCompletionCoordinatorPortTypeImpl", "BusinessAgreementWithParticipantCompletionCoordinatorService"), new EndpointInfo("com.arjuna.webservices11.wsarjtx.sei.TerminationCoordinatorPortTypeImpl", "TerminationCoordinatorService"), new EndpointInfo("com.arjuna.webservices11.wsarjtx.sei.TerminationCoordinatorRPCPortTypeImpl", "TerminationCoordinatorRPCService")}), new ContextInfo("ws-t11-participant", new EndpointInfo[]{new EndpointInfo("com.arjuna.webservices11.wsat.sei.ParticipantPortTypeImpl", "ParticipantService"), new EndpointInfo("com.arjuna.webservices11.wsba.sei.BusinessAgreementWithCoordinatorCompletionParticipantPortTypeImpl", "BusinessAgreementWithCoordinatorCompletionParticipantService"), new EndpointInfo("com.arjuna.webservices11.wsba.sei.BusinessAgreementWithParticipantCompletionParticipantPortTypeImpl", "BusinessAgreementWithParticipantCompletionParticipantService")}), new ContextInfo("ws-t11-client", new EndpointInfo[]{new EndpointInfo("com.arjuna.webservices11.wsat.sei.CompletionInitiatorPortTypeImpl", "CompletionInitiatorService"), new EndpointInfo("com.arjuna.webservices11.wsarjtx.sei.TerminationParticipantPortTypeImpl", "TerminationParticipantService")})};

    private XTSSubsystemAdd() {
    }

    static ContextInfo[] getContextDefinitions() {
        return contextDefinitions;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        XTSSubsystemDefinition.HOST_NAME.validateAndSet(operation, model);
        XTSSubsystemDefinition.ENVIRONMENT_URL.validateAndSet(operation, model);
        XTSSubsystemDefinition.DEFAULT_CONTEXT_PROPAGATION.validateAndSet(operation, model);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String coordinatorURL;
        String hostName = XTSSubsystemDefinition.HOST_NAME.resolveModelAttribute(context, model).asString();
        ModelNode coordinatorURLAttribute = XTSSubsystemDefinition.ENVIRONMENT_URL.resolveModelAttribute(context, model);
        String string = coordinatorURL = coordinatorURLAttribute.isDefined() ? coordinatorURLAttribute.asString() : null;
        if (coordinatorURL != null && XtsAsLogger.ROOT_LOGGER.isDebugEnabled()) {
            XtsAsLogger.ROOT_LOGGER.debugf("nodeIdentifier=%s\n", coordinatorURL);
        }
        boolean isDefaultContextPropagation = model.hasDefined("default-context-propagation") ? model.get("default-context-propagation").asBoolean() : false;
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("xts", Phase.PARSE, 8281, (DeploymentUnitProcessor)new XTSInterceptorDeploymentProcessor());
                processorTarget.addDeploymentProcessor("xts", Phase.PARSE, 8279, (DeploymentUnitProcessor)new XTSHandlerDeploymentProcessor());
                processorTarget.addDeploymentProcessor("xts", Phase.DEPENDENCIES, 4368, (DeploymentUnitProcessor)new XTSDependenciesDeploymentProcessor());
                processorTarget.addDeploymentProcessor("xts", Phase.POST_MODULE, 3600, (DeploymentUnitProcessor)new CDIExtensionProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        ServiceTarget target = context.getServiceTarget();
        ClassLoader loader = XTSService.class.getClassLoader();
        ArrayList<ServiceController> controllers = new ArrayList<ServiceController>();
        for (ContextInfo contextInfo : contextDefinitions) {
            String contextName = contextInfo.contextPath;
            HashMap<String, String> map = new HashMap<String, String>();
            for (EndpointInfo endpointInfo : contextInfo.endpointInfo) {
                map.put(endpointInfo.URLPattern, endpointInfo.SEIClassname);
            }
            ServiceBuilder endpointBuilder = EndpointPublishService.createServiceBuilder((ServiceTarget)target, (String)contextName, (ClassLoader)loader, (String)hostName, map);
            controllers.add(endpointBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install());
        }
        XTSHandlersService.install(target, isDefaultContextPropagation);
        XTSManagerService xtsService = new XTSManagerService(coordinatorURL);
        ServiceBuilder xtsServiceBuilder = target.addService(XTSServices.JBOSS_XTS_MAIN, (Service)xtsService);
        xtsServiceBuilder.addDependency(TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER);
        xtsServiceBuilder.addDependency(WSServices.CONFIG_SERVICE, ServerConfig.class, xtsService.getWSServerConfig());
        xtsServiceBuilder.addDependency(WSServices.XTS_CLIENT_INTEGRATION_SERVICE);
        for (ServiceController controller : controllers) {
            xtsServiceBuilder.addDependency(controller.getName());
        }
        xtsServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        TxBridgeInboundRecoveryService txBridgeInboundRecoveryService = new TxBridgeInboundRecoveryService();
        ServiceBuilder txBridgeInboundRecoveryServiceBuilder = target.addService(XTSServices.JBOSS_XTS_TXBRIDGE_INBOUND_RECOVERY, (Service)txBridgeInboundRecoveryService);
        txBridgeInboundRecoveryServiceBuilder.addDependency(XTSServices.JBOSS_XTS_MAIN);
        txBridgeInboundRecoveryServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        TxBridgeOutboundRecoveryService txBridgeOutboundRecoveryService = new TxBridgeOutboundRecoveryService();
        ServiceBuilder txBridgeOutboundRecoveryServiceBuilder = target.addService(XTSServices.JBOSS_XTS_TXBRIDGE_OUTBOUND_RECOVERY, (Service)txBridgeOutboundRecoveryService);
        txBridgeOutboundRecoveryServiceBuilder.addDependency(XTSServices.JBOSS_XTS_MAIN);
        txBridgeOutboundRecoveryServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    static class ContextInfo {
        String contextPath;
        EndpointInfo[] endpointInfo;

        ContextInfo(String contextPath, EndpointInfo[] endpointInfo) {
            this.contextPath = contextPath;
            this.endpointInfo = endpointInfo;
        }
    }

    private static class EndpointInfo {
        String SEIClassname;
        String URLPattern;

        EndpointInfo(String seiClassname, String urlPattern) {
            this.SEIClassname = seiClassname;
            this.URLPattern = urlPattern;
        }
    }
}

