/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class PropertiesAttributeDefinition
extends MapAttributeDefinition {
    private PropertiesAttributeDefinition(Builder builder) {
        super(builder);
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        this.setValueType(node);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.setValueType(node);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.setValueType(node);
    }

    void setValueType(ModelNode node) {
        node.get("value-type").set(ModelType.STRING);
        if (this.isAllowExpression()) {
            node.get("expressions-allowed").set(new ModelNode(true));
        }
    }

    public Map<String, String> unwrap(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.hasDefined(this.getName())) {
            return new HashMap<String, String>();
        }
        ModelNode modelProps = model.get(this.getName());
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property p : modelProps.asPropertyList()) {
            props.put(p.getName(), context.resolveExpressions(p.getValue()).asString());
        }
        return props;
    }

    public void parse(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (reader.getLocalName().equals(this.getXmlName())) {
                String[] array = ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
                this.parseAndAddParameterElement(array[0], array[1], operation, reader);
                ParseUtils.requireNoContent(reader);
                continue;
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static class Builder
    extends MapAttributeDefinition.Builder<Builder, PropertiesAttributeDefinition> {
        private boolean wrapXmlElement = true;
        private String wrapperElement = null;

        public Builder(String name, boolean allowNull) {
            super(name, allowNull);
        }

        public Builder(PropertiesAttributeDefinition basis) {
            super(basis);
        }

        public Builder(MapAttributeDefinition basis) {
            super(basis);
        }

        public Builder setWrapXmlElement(boolean wrap) {
            this.wrapXmlElement = wrap;
            return this;
        }

        public Builder setWrapperElement(String name) {
            this.wrapperElement = name;
            return this;
        }

        @Override
        public PropertiesAttributeDefinition build() {
            if (this.elementValidator == null) {
                this.elementValidator = new ModelTypeValidator(ModelType.STRING, this.allowNull, this.allowExpression);
            }
            if (this.attributeMarshaller == null) {
                this.attributeMarshaller = new PropertiesAttributeMarshaller(this.wrapXmlElement, this.wrapperElement);
            }
            return new PropertiesAttributeDefinition(this);
        }
    }

    private static class PropertiesAttributeMarshaller
    extends AttributeMarshaller {
        private final boolean wrapElement;
        private final String wrapperElement;

        protected PropertiesAttributeMarshaller(boolean wrapElement, String wrapperElement) {
            this.wrapElement = wrapElement;
            this.wrapperElement = wrapperElement;
        }

        @Override
        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
            return resourceModel.isDefined() && resourceModel.hasDefined(attribute.getName());
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            resourceModel = resourceModel.get(attribute.getName());
            if (this.wrapElement) {
                writer.writeStartElement(this.wrapperElement == null ? attribute.getName() : this.wrapperElement);
            }
            for (ModelNode property : resourceModel.asList()) {
                writer.writeEmptyElement(attribute.getXmlName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.asProperty().getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), property.asProperty().getValue().asString());
            }
            if (this.wrapElement) {
                writer.writeEndElement();
            }
        }

        @Override
        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            this.marshallAsElement(attribute, resourceModel, marshallDefault, writer);
        }

        @Override
        public boolean isMarshallableAsElement() {
            return true;
        }
    }
}

