/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.audit.AuditLogItem;
import org.jboss.as.controller.audit.AuditLogItemFormatter;

abstract class AuditLogHandler {
    private volatile int maxFailureCount = 10;
    private int failureCount;
    protected final String name;
    private volatile String formatterName;
    private final Set<PathAddress> references = new HashSet<PathAddress>();
    private AuditLogItemFormatter formatter;

    AuditLogHandler(String name, String formatterName, int maxFailureCount) {
        this.name = name;
        this.formatterName = formatterName;
        this.maxFailureCount = maxFailureCount;
    }

    String getName() {
        return this.name;
    }

    void setFormatter(AuditLogItemFormatter formatter) {
        this.formatter = formatter;
    }

    String getFormatterName() {
        return this.formatterName;
    }

    public void setMaxFailureCount(int count) {
        this.maxFailureCount = count;
    }

    public void setFormatterName(String formatterName) {
        this.formatterName = formatterName;
    }

    void writeLogItem(AuditLogItem item) {
        block2: {
            try {
                this.initialize();
                String formattedItem = item.format(this.formatter);
                this.writeLogItem(formattedItem);
                this.failureCount = 0;
            }
            catch (Throwable t) {
                ++this.failureCount;
                ControllerLogger.MGMT_OP_LOGGER.logHandlerWriteFailed(t, this.name);
                if (!this.isDisabledDueToFailures()) break block2;
                ControllerLogger.MGMT_OP_LOGGER.disablingLogHandlerDueToFailures(this.failureCount, this.name);
            }
        }
    }

    void recycle() {
        this.failureCount = 0;
        this.stop();
    }

    boolean isDisabledDueToFailures() {
        return this.maxFailureCount > 0 && this.failureCount >= this.maxFailureCount;
    }

    void addReference(PathAddress address) {
        this.references.add(address);
    }

    void removeReference(PathAddress address) {
        this.references.remove(address);
        if (this.references.size() == 0) {
            this.stop();
        }
    }

    Set<PathAddress> getReferences() {
        return this.references;
    }

    int getFailureCount() {
        return this.failureCount;
    }

    abstract boolean isDifferent(AuditLogHandler var1);

    abstract void initialize();

    abstract void stop();

    abstract void writeLogItem(String var1) throws IOException;
}

