/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.regex.Pattern;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.interfaces.AbstractInterfaceCriteria;

public class NicMatchInterfaceCriteria
extends AbstractInterfaceCriteria {
    private static final long serialVersionUID = 6456168020697683203L;
    private final Pattern pattern;

    public NicMatchInterfaceCriteria(Pattern pattern) {
        if (pattern == null) {
            throw ControllerMessages.MESSAGES.nullVar("pattern");
        }
        this.pattern = pattern;
    }

    public Pattern getAcceptablePattern() {
        return this.pattern;
    }

    @Override
    protected InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
        if (this.pattern.matcher(networkInterface.getName()).matches()) {
            return address;
        }
        return null;
    }

    public int hashCode() {
        return this.pattern.toString().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof NicMatchInterfaceCriteria && this.pattern.toString().equals(((NicMatchInterfaceCriteria)o).pattern.toString());
    }
}

