/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

public enum CharacterType {
    NORMAL(0),
    BOLD(1),
    PLAIN(2),
    ITALIC(3),
    UNDERLINE(4),
    BLINK(5),
    INVERT(7),
    CROSSED_OUT(9);

    private int value;
    private static int BOLD_OFF;
    private static int ITALIC_OFF;
    private static int UNDERLINE_OFF;
    private static int BLINK_OFF;
    private static int INVERT_OFF;
    private static int CROSSED_OUT_OFF;

    private CharacterType(int c) {
        this.value = c;
    }

    public int getValue() {
        return this.value;
    }

    public String getValueComparedToPrev(CharacterType prev) {
        StringBuilder builder = new StringBuilder();
        if (this != prev) {
            if (prev == BOLD || prev == PLAIN) {
                builder.append(BOLD_OFF).append(';');
            } else if (prev == UNDERLINE) {
                builder.append(UNDERLINE_OFF).append(';');
            } else if (prev == ITALIC) {
                builder.append(ITALIC_OFF).append(';');
            } else if (prev == BLINK) {
                builder.append(BLINK_OFF).append(';');
            } else if (prev == INVERT) {
                builder.append(INVERT_OFF).append(';');
            } else if (prev == CROSSED_OUT) {
                builder.append(CROSSED_OUT_OFF).append(';');
            }
        }
        builder.append(this.getValue());
        return builder.toString();
    }

    static {
        BOLD_OFF = 22;
        ITALIC_OFF = 23;
        UNDERLINE_OFF = 24;
        BLINK_OFF = 25;
        INVERT_OFF = 27;
        CROSSED_OUT_OFF = 29;
    }
}

