/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;

public class HornetQChannelHandler
extends ChannelDuplexHandler {
    private final ChannelGroup group;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    volatile boolean active;

    protected HornetQChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
        this.group = group;
        this.handler = handler;
        this.listener = listener;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.group.add(ctx.channel());
        ctx.fireChannelActive();
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.listener.connectionReadyForWrites(HornetQChannelHandler.channelId(ctx.channel()), ctx.channel().isWritable());
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg;
        this.handler.bufferReceived(HornetQChannelHandler.channelId(ctx.channel()), new ChannelBufferWrapper(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        HornetQChannelHandler hornetQChannelHandler = this;
        synchronized (hornetQChannelHandler) {
            if (this.active) {
                this.listener.connectionDestroyed(HornetQChannelHandler.channelId(ctx.channel()));
                this.active = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.active) {
            return;
        }
        HornetQInternalErrorException me = HornetQClientMessageBundle.BUNDLE.nettyError();
        me.initCause(cause);
        ConnectionLifeCycleListener connectionLifeCycleListener = this.listener;
        synchronized (connectionLifeCycleListener) {
            try {
                this.listener.connectionException(HornetQChannelHandler.channelId(ctx.channel()), me);
                this.active = false;
            }
            catch (Exception ex) {
                HornetQClientLogger.LOGGER.errorCallingLifeCycleListener(ex);
            }
        }
    }

    protected static int channelId(Channel channel) {
        return channel.hashCode();
    }
}

