/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.fork;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.MessageBatch;

public class ForkProtocolStack
extends ProtocolStack {
    protected Address local_addr;
    protected final ConcurrentMap<String, JChannel> fork_channels = new ConcurrentHashMap<String, JChannel>();

    public JChannel get(String fork_channel_id) {
        return (JChannel)this.fork_channels.get(fork_channel_id);
    }

    public JChannel putIfAbsent(String fork_channel_id, JChannel fork_channel) {
        return this.fork_channels.putIfAbsent(fork_channel_id, fork_channel);
    }

    public void remove(String fork_channel_id) {
        this.fork_channels.remove(fork_channel_id);
    }

    @Override
    public Object down(Event evt) {
        return this.down_prot.down(evt);
    }

    public void setLocalAddress(Address addr) {
        if (this.local_addr != null && addr != null && this.local_addr.equals(addr)) {
            return;
        }
        this.local_addr = addr;
        this.down_prot.down(new Event(8, addr));
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FORK.ForkHeader hdr = (FORK.ForkHeader)msg.getHeader(FORK.ID);
                if (hdr == null) break;
                if (hdr.getForkChannelId() == null) {
                    throw new IllegalArgumentException("header has a null fork_channel_id");
                }
                JChannel fork_channel = this.get(hdr.getForkChannelId());
                return fork_channel.up(evt);
            }
            case 6: {
                for (JChannel ch : this.fork_channels.values()) {
                    ch.up(evt);
                }
                break;
            }
        }
        return null;
    }

    @Override
    public void up(MessageBatch batch) {
        ArrayList<Message> list;
        HashMap<String, ArrayList<Message>> map = new HashMap<String, ArrayList<Message>>();
        for (Message message : batch) {
            FORK.ForkHeader hdr = (FORK.ForkHeader)message.getHeader(FORK.ID);
            if (hdr == null) continue;
            batch.remove(message);
            list = (List)map.get(hdr.getForkChannelId());
            if (list == null) {
                list = new ArrayList<Message>();
                map.put(hdr.getForkChannelId(), list);
            }
            list.add(message);
        }
        for (Map.Entry entry : map.entrySet()) {
            String fork_channel_id = (String)entry.getKey();
            list = (ArrayList<Message>)entry.getValue();
            JChannel fork_channel = this.get(fork_channel_id);
            if (fork_channel == null) {
                this.log.warn("fork-channel for id=%s not found; discarding message", fork_channel_id);
                continue;
            }
            MessageBatch mb = new MessageBatch(batch.dest(), batch.sender(), batch.clusterName(), batch.multicast(), list);
            try {
                fork_channel.up(mb);
            }
            catch (Throwable t) {
                this.log.error("failed passing up batch", t);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }
}

