/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.logging.CustomFormatterResourceDefinition;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.LoggingResource;
import org.jboss.as.logging.LoggingResourceDefinition;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.RootLoggerResourceDefinition;
import org.jboss.as.logging.deployments.LoggingConfigDeploymentProcessor;
import org.jboss.as.logging.deployments.LoggingDependencyDeploymentProcessor;
import org.jboss.as.logging.deployments.LoggingProfileDeploymentProcessor;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.msc.service.ServiceController;

class LoggingSubsystemAdd
extends AbstractAddStepHandler {
    private final PathManager pathManager;

    LoggingSubsystemAdd(PathManager pathManager) {
        super((AttributeDefinition[])LoggingResourceDefinition.ATTRIBUTES);
        this.pathManager = pathManager;
    }

    protected Resource createResource(OperationContext context) {
        if (this.pathManager == null) {
            return super.createResource(context);
        }
        LoggingResource resource = new LoggingResource(this.pathManager);
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        return resource;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        for (SimpleAttributeDefinition attribute : LoggingResourceDefinition.ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        final boolean addDependencies = LoggingResourceDefinition.ADD_LOGGING_API_DEPENDENCIES.resolveModelAttribute(context, model).asBoolean();
        final boolean useLoggingConfig = LoggingResourceDefinition.USE_DEPLOYMENT_LOGGING_CONFIG.resolveModelAttribute(context, model).asBoolean();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                if (addDependencies) {
                    processorTarget.addDeploymentProcessor("logging", Phase.DEPENDENCIES, 7424, (DeploymentUnitProcessor)new LoggingDependencyDeploymentProcessor());
                }
                processorTarget.addDeploymentProcessor("logging", Phase.POST_MODULE, 11008, (DeploymentUnitProcessor)new LoggingConfigDeploymentProcessor(LoggingExtension.CONTEXT_SELECTOR, LoggingResourceDefinition.USE_DEPLOYMENT_LOGGING_CONFIG.getName(), useLoggingConfig));
                processorTarget.addDeploymentProcessor("logging", Phase.POST_MODULE, 11024, (DeploymentUnitProcessor)new LoggingProfileDeploymentProcessor(LoggingExtension.CONTEXT_SELECTOR));
            }
        }, OperationContext.Stage.RUNTIME);
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ConfigurationPersistence configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence();
        LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
        if (!resource.hasChild(RootLoggerResourceDefinition.ROOT_LOGGER_PATH)) {
            LoggingLogger.ROOT_LOGGER.tracef("Removing the root logger configuration.", new Object[0]);
            logContextConfiguration.removeLoggerConfiguration("");
        }
        if (resource.hasChild(PathElement.pathElement((String)"logger"))) {
            Set loggerNames = resource.getChildrenNames("logger");
            List configuredLoggerNames = logContextConfiguration.getLoggerNames();
            configuredLoggerNames.remove("");
            configuredLoggerNames.removeAll(loggerNames);
            for (String name : configuredLoggerNames) {
                LoggingLogger.ROOT_LOGGER.tracef("Removing logger configuration for '%s'", name);
                logContextConfiguration.removeLoggerConfiguration(name);
            }
        }
        ArrayList subsystemHandlers = new ArrayList();
        subsystemHandlers.addAll(resource.getChildrenNames("async-handler"));
        subsystemHandlers.addAll(resource.getChildrenNames("console-handler"));
        subsystemHandlers.addAll(resource.getChildrenNames("custom-handler"));
        subsystemHandlers.addAll(resource.getChildrenNames("file-handler"));
        subsystemHandlers.addAll(resource.getChildrenNames("periodic-rotating-file-handler"));
        subsystemHandlers.addAll(resource.getChildrenNames("size-rotating-file-handler"));
        List configuredHandlerNames = logContextConfiguration.getHandlerNames();
        configuredHandlerNames.removeAll(subsystemHandlers);
        for (String name : configuredHandlerNames) {
            LoggingLogger.ROOT_LOGGER.tracef("Removing handler configuration for '%s'", name);
            logContextConfiguration.removePojoConfiguration(name);
            logContextConfiguration.removeHandlerConfiguration(name);
        }
        List configuredFormatters = logContextConfiguration.getFormatterNames();
        configuredFormatters.removeAll(resource.getChildrenNames(PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName()));
        configuredFormatters.removeAll(resource.getChildrenNames(CustomFormatterResourceDefinition.CUSTOM_FORMATTER.getName()));
        configuredFormatters.removeAll(subsystemHandlers);
        for (String name : configuredFormatters) {
            LoggingLogger.ROOT_LOGGER.tracef("Removing formatter configuration for '%s'", name);
            logContextConfiguration.removeFormatterConfiguration(name);
        }
        LoggingOperations.addCommitStep(context, configurationPersistence);
        LoggingLogger.ROOT_LOGGER.trace("Logging subsystem has been added.");
    }
}

