/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.origin.hql.resolve.path;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.internal.util.Strings;

public class PropertyPath {
    private final LinkedList<PathedPropertyReferenceSource> path;

    public PropertyPath() {
        this.path = new LinkedList();
    }

    public PropertyPath(PropertyPath path) {
        this.path = path.path;
    }

    public void appendNode(PathedPropertyReferenceSource property) {
        this.path.add(property);
    }

    public PathedPropertyReferenceSource getLastNode() {
        return this.path.getLast();
    }

    public List<PathedPropertyReferenceSource> getNodes() {
        return new LinkedList<PathedPropertyReferenceSource>(this.path);
    }

    public String asStringPathWithoutAlias() {
        if (this.path.isEmpty()) {
            return null;
        }
        return Strings.join(this.getNodeNamesWithoutAlias(), ".");
    }

    public List<String> getNodeNamesWithoutAlias() {
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (PathedPropertyReferenceSource node : this.path) {
            if (node.isAlias()) continue;
            nodeNames.add(node.getName());
        }
        return nodeNames;
    }

    public String toString() {
        return "PropertyPath [path=" + this.path + "]";
    }
}

