/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.bridge.inbound;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.recovery.SerializableXAResourceDeserializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeException;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeRecoveryModule;

public final class InboundBridge
implements XAResource,
SerializableXAResourceDeserializer,
Serializable {
    public static final int XARESOURCE_FORMAT_ID = 131081;
    private static final Logger LOG = Logger.getLogger(InboundBridge.class);
    private Xid xid;
    private String enlistmentUrl;

    public InboundBridge() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridge.InboundBridge");
        }
    }

    public InboundBridge(Xid xid, String enlistmentUrl) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.InboundBridge: xid=" + xid + ", enlistmentUrl=" + enlistmentUrl));
        }
        this.xid = xid;
        this.enlistmentUrl = enlistmentUrl;
        this.enlist(this);
    }

    public void start() {
        Transaction transaction;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.start " + this));
        }
        if (!this.isTransactionGoodToResume(transaction = this.getTransaction())) {
            throw new InboundBridgeException("Transaction is not in an active state.");
        }
        try {
            TransactionManager.transactionManager().resume(transaction);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            throw new InboundBridgeException("Failed to start the bridge.", e);
        }
    }

    public void stop() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.stop " + this));
        }
        try {
            TransactionManager.transactionManager().suspend();
        }
        catch (SystemException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            throw new InboundBridgeException("Failed to stop the bridge.", e);
        }
    }

    public Xid getXid() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.getXid " + this));
        }
        return this.xid;
    }

    public void setXid(Xid xid) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.setXid: xid=" + xid + ". " + this));
        }
        this.xid = xid;
    }

    public String getEnlistmentUrl() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.getEnlistmentUrl " + this));
        }
        return this.enlistmentUrl;
    }

    public void setEnlistmentUrl(String enlistmentUrl) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.setEnlistmentUrl: enlistmentUrl=" + enlistmentUrl + ". " + this));
        }
        this.enlistmentUrl = enlistmentUrl;
    }

    public boolean equals(Object o) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeImpl.equals: o=" + o + ". " + this));
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof InboundBridge)) {
            return false;
        }
        InboundBridge inboundBridge = (InboundBridge)o;
        return this.xid.equals(inboundBridge.xid) && this.enlistmentUrl.equals(inboundBridge.enlistmentUrl);
    }

    public int hashCode() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridgeImpl.hashCode " + this));
        }
        int hash = 1;
        hash = hash * 17 * this.xid.hashCode();
        hash = hash * 31 * this.enlistmentUrl.hashCode();
        return hash;
    }

    public String toString() {
        return "<InboundBridge: xid=" + this.xid + ", enlistmentUrl=" + this.enlistmentUrl + ">";
    }

    private void enlist(InboundBridge inboundBridge) {
        Transaction transaction = this.getTransaction();
        if (!this.isTransactionGoodToEnlist(transaction)) {
            throw new InboundBridgeException("Transaction is not in an active state.");
        }
        try {
            transaction.enlistResource((XAResource)inboundBridge);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            throw new InboundBridgeException("Failed to enlist inbound bridge to the transaction.", e);
        }
    }

    private Transaction getTransaction() {
        SubordinateTransaction transaction;
        try {
            transaction = SubordinationManager.getTransactionImporter().importTransaction(this.xid);
        }
        catch (XAException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            throw new InboundBridgeException("Failed to import transaction.", e);
        }
        return transaction;
    }

    private boolean isTransactionGoodToEnlist(Transaction transaction) {
        try {
            return transaction.getStatus() == 0;
        }
        catch (SystemException e) {
            LOG.warn((Object)e.getMessage());
            return false;
        }
    }

    private boolean isTransactionGoodToResume(Transaction transaction) {
        try {
            int status = transaction.getStatus();
            return status == 0 || status == 1 || status == 8;
        }
        catch (SystemException e) {
            LOG.warn((Object)e.getMessage());
            return false;
        }
    }

    public boolean canDeserialze(String className) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridge.canDeserialze");
        }
        return this.getClass().getName().equals(className);
    }

    public XAResource deserialze(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridge.deserialze");
        }
        InboundBridge inboundBridge = (InboundBridge)ois.readObject();
        InboundBridgeRecoveryModule.addRecoveredBridge(inboundBridge);
        return inboundBridge;
    }

    @Override
    public void commit(Xid xid, boolean b) throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.commit: xid=" + xid + ", b=" + b));
        }
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.end: xid=" + xid + ", i=" + i));
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.forget: xid=" + xid));
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"InboundBridge.getTransactionTimeout");
        }
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource resource) throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.isSameRM: resource=" + resource));
        }
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.prepare: xid=" + xid));
        }
        return 0;
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.recover: i=" + i));
        }
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.rollback: xid=" + xid));
        }
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.setTransactionTimeout: i=" + i));
        }
        return false;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("InboundBridge.start: xid=" + xid + ", i=" + i));
        }
    }
}

