/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.stream;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class CRLFPrintWriter
extends PrintWriter {
    protected boolean autoFlush = false;

    public CRLFPrintWriter(Writer out) {
        super(out);
    }

    public CRLFPrintWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
        this.autoFlush = autoFlush;
    }

    public CRLFPrintWriter(OutputStream out) {
        super(out);
    }

    public CRLFPrintWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
        this.autoFlush = autoFlush;
    }

    protected void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write("\r\n");
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }
}

