/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.security.LdapCacheService;
import org.jboss.as.domain.management.security.LdapConnectionHandler;
import org.jboss.as.domain.management.security.LdapSearcher;
import org.jboss.as.domain.management.security.LdapSearcherCache;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

class LdapCacheService<R, K>
implements Service<LdapSearcherCache<R, K>> {
    private static volatile int THREAD_COUNT = 1;
    private final LdapSearcher<R, K> searcher;
    private volatile CacheMode mode;
    private volatile int evictionTime;
    private volatile boolean cacheFailures;
    private volatile int maxCacheSize;
    private volatile ExtendedLdapSearcherCache<R, K> cacheImplementation;
    private ScheduledExecutorService executorService;

    private LdapCacheService(LdapSearcher<R, K> searcher, CacheMode mode, int evictionTime, boolean cacheFailures, int maxCacheSize) {
        this.searcher = searcher;
        this.mode = mode;
        this.evictionTime = evictionTime;
        this.cacheFailures = cacheFailures;
        this.maxCacheSize = maxCacheSize;
    }

    static <R, K> LdapCacheService<R, K> createNoCacheService(LdapSearcher<R, K> searcher) {
        return new LdapCacheService<R, K>(searcher, CacheMode.OFF, 0, false, 0);
    }

    static <R, K> LdapCacheService<R, K> createBySearchCacheService(LdapSearcher<R, K> searcher, int evictionTime, boolean cacheFailure, int maxSize) {
        return new LdapCacheService<R, K>(searcher, CacheMode.BY_SEARCH, evictionTime, cacheFailure, maxSize);
    }

    static <R, K> LdapCacheService<R, K> createByAccessCacheService(LdapSearcher<R, K> searcher, int evictionTime, boolean cacheFailure, int maxSize) {
        return new LdapCacheService<R, K>(searcher, CacheMode.BY_ACCESS, evictionTime, cacheFailure, maxSize);
    }

    public LdapSearcherCache<R, K> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.cacheImplementation;
    }

    public void start(StartContext context) throws StartException {
        switch (this.mode) {
            case OFF: {
                this.cacheImplementation = new NoCacheCache();
                break;
            }
            case BY_ACCESS: {
                this.cacheImplementation = new ByAccessCache(this.evictionTime, this.cacheFailures, this.maxCacheSize);
                break;
            }
            case BY_SEARCH: {
                this.cacheImplementation = new BySearchCache(this.evictionTime, this.cacheFailures, this.maxCacheSize);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown cache mode '%s'", new Object[]{this.mode}));
            }
        }
        if (this.evictionTime > 0) {
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, String.format("LDAP Cache Eviction Thread (%d)", THREAD_COUNT++));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        try {
            context.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LdapCacheService.this.cacheImplementation.clearAll();
                        LdapCacheService.this.cacheImplementation = null;
                        if (LdapCacheService.this.executorService != null) {
                            LdapCacheService.this.executorService.shutdown();
                            LdapCacheService.this.executorService = null;
                        }
                    }
                    finally {
                        context.complete();
                    }
                }
            });
        }
        finally {
            context.asynchronous();
        }
    }

    public CacheMode getMode() {
        return this.mode;
    }

    public void setMode(CacheMode mode) {
        this.mode = mode;
    }

    public int getEvictionTime() {
        return this.evictionTime;
    }

    public void setEvictionTime(int evictionTime) {
        this.evictionTime = evictionTime;
    }

    public boolean isCacheFailures() {
        return this.cacheFailures;
    }

    public void setCacheFailures(boolean cacheFailures) {
        this.cacheFailures = cacheFailures;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    private R internalSearch(LdapConnectionHandler connectionHandler, K key) throws IOException, NamingException {
        return this.searcher.search(connectionHandler, key);
    }

    private class SearchResultImpl<R>
    implements LdapSearcherCache.SearchResult<R> {
        private final ConcurrentMap<LdapSearcherCache.AttachmentKey<?>, Object> valueAttachments = new ConcurrentHashMap();
        private final R result;

        private SearchResultImpl(R result) {
            this.result = result;
        }

        @Override
        public R getResult() {
            return this.result;
        }

        @Override
        public <T> T getAttachment(LdapSearcherCache.AttachmentKey<T> key) {
            return key.cast(this.valueAttachments.get(key));
        }

        @Override
        public <T> T attach(LdapSearcherCache.AttachmentKey<T> key, T value) {
            return key.cast(this.valueAttachments.put(key, value));
        }

        @Override
        public <T> T detach(LdapSearcherCache.AttachmentKey<T> key) {
            return key.cast(this.valueAttachments.remove(key));
        }
    }

    private class ByAccessCache
    extends BaseSearchCache {
        private ByAccessCache(int evictionTime, boolean cacheFailures, int maxSize) {
            super(evictionTime, cacheFailures, maxSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LdapSearcherCache.SearchResult<R> search(LdapConnectionHandler connectionHandler, final K key) throws IOException, NamingException {
            BaseSearchCache.CacheEntry entry = null;
            LinkedHashMap linkedHashMap = this.theCache;
            synchronized (linkedHashMap) {
                entry = (BaseSearchCache.CacheEntry)this.theCache.remove(key);
                if (entry == null) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Entry for '%s' not found in cache.", key);
                    entry = new BaseSearchCache.CacheEntry();
                    if (this.maxSize > 0 && this.theCache.size() + 1 > this.maxSize) {
                        boolean trace = DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled();
                        Iterator it = this.theCache.entrySet().iterator();
                        while (this.theCache.size() + 1 > this.maxSize) {
                            Map.Entry current = it.next();
                            ((BaseSearchCache.CacheEntry)current.getValue()).cancelFuture();
                            it.remove();
                            if (!trace) continue;
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Entry with key '%s' evicted from cache due to cache being above maximum size.", current.getKey());
                        }
                    }
                } else {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Cached entry for '%s' found in cache.", key);
                }
                this.theCache.put(key, entry);
                if (this.evictionTime > 0) {
                    entry.cancelFuture();
                    entry.setFuture(LdapCacheService.this.executorService.schedule(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            LinkedHashMap linkedHashMap = ByAccessCache.this.theCache;
                            synchronized (linkedHashMap) {
                                BaseSearchCache.CacheEntry entry = (BaseSearchCache.CacheEntry)ByAccessCache.this.theCache.remove(key);
                                if (entry == null) {
                                    DomainManagementLogger.SECURITY_LOGGER.tracef("Entry with key '%s' not in cache at time of timeout.", key);
                                } else {
                                    DomainManagementLogger.SECURITY_LOGGER.tracef("Evicted entry with key '%s' due to eviction timeout.", key);
                                }
                            }
                        }
                    }, (long)this.evictionTime, TimeUnit.SECONDS));
                }
            }
            return entry.getSearchResult(connectionHandler, key);
        }
    }

    private class BySearchCache
    extends BaseSearchCache {
        private BySearchCache(int evictionTime, boolean cacheFailures, int maxSize) {
            super(evictionTime, cacheFailures, maxSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LdapSearcherCache.SearchResult<R> search(LdapConnectionHandler connectionHandler, final K key) throws IOException, NamingException {
            BaseSearchCache.CacheEntry entry = null;
            LinkedHashMap linkedHashMap = this.theCache;
            synchronized (linkedHashMap) {
                entry = (BaseSearchCache.CacheEntry)this.theCache.get(key);
                if (entry == null) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Entry for '%s' not found in cache.", key);
                    entry = new BaseSearchCache.CacheEntry();
                    this.theCache.put(key, entry);
                    if (this.maxSize > 0 && this.theCache.size() > this.maxSize) {
                        boolean trace = DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled();
                        Iterator it = this.theCache.entrySet().iterator();
                        while (this.theCache.size() > this.maxSize) {
                            Map.Entry current = it.next();
                            ((BaseSearchCache.CacheEntry)current.getValue()).cancelFuture();
                            it.remove();
                            if (!trace) continue;
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Entry with key '%s' evicted from cache due to cache being above maximum size.", current.getKey());
                        }
                    }
                    if (this.evictionTime > 0) {
                        entry.setFuture(LdapCacheService.this.executorService.schedule(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                LinkedHashMap linkedHashMap = BySearchCache.this.theCache;
                                synchronized (linkedHashMap) {
                                    BaseSearchCache.CacheEntry entry = (BaseSearchCache.CacheEntry)BySearchCache.this.theCache.remove(key);
                                    if (entry == null) {
                                        DomainManagementLogger.SECURITY_LOGGER.tracef("Entry with key '%s' not in cache at time of timeout.", key);
                                    } else {
                                        DomainManagementLogger.SECURITY_LOGGER.tracef("Evicted entry with key '%s' due to eviction timeout.", key);
                                    }
                                }
                            }
                        }, (long)this.evictionTime, TimeUnit.SECONDS));
                    }
                } else {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Cached entry for '%s' found in cache.", key);
                }
            }
            return entry.getSearchResult(connectionHandler, key);
        }
    }

    private abstract class BaseSearchCache
    implements ExtendedLdapSearcherCache<R, K> {
        protected final int evictionTime;
        protected final boolean cacheFailures;
        protected final int maxSize;
        protected final LinkedHashMap<K, org.jboss.as.domain.management.security.LdapCacheService$BaseSearchCache.CacheEntry> theCache = new LinkedHashMap();

        private BaseSearchCache(int evictionTime, boolean cacheFailures, int maxSize) {
            this.evictionTime = evictionTime;
            this.cacheFailures = cacheFailures;
            this.maxSize = maxSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCurrentSize() {
            LinkedHashMap linkedHashMap = this.theCache;
            synchronized (linkedHashMap) {
                return this.theCache.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearAll() {
            LinkedHashMap linkedHashMap = this.theCache;
            synchronized (linkedHashMap) {
                Iterator<org.jboss.as.domain.management.security.LdapCacheService$BaseSearchCache.CacheEntry> it = this.theCache.values().iterator();
                while (it.hasNext()) {
                    CacheEntry current = (CacheEntry)it.next();
                    current.cancelFuture();
                    it.remove();
                }
            }
            DomainManagementLogger.SECURITY_LOGGER.trace("Cleared whole cache.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear(K key) {
            LinkedHashMap linkedHashMap = this.theCache;
            synchronized (linkedHashMap) {
                CacheEntry entry = (CacheEntry)this.theCache.remove(key);
                if (entry != null) {
                    entry.cancelFuture();
                }
            }
            DomainManagementLogger.SECURITY_LOGGER.tracef("Cleared entry from cache with key '%s'", key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear(LdapSearcherCache.Predicate<K> predicate) {
            LinkedHashMap linkedHashMap = this.theCache;
            synchronized (linkedHashMap) {
                Iterator it = this.theCache.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry current = it.next();
                    Object key = current.getKey();
                    if (!predicate.matches(key)) continue;
                    it.remove();
                    ((CacheEntry)current.getValue()).cancelFuture();
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Cleared entry from cache with key '%s' based on predicate match.", key);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(K key) {
            LinkedHashMap linkedHashMap = this.theCache;
            synchronized (linkedHashMap) {
                return this.theCache.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int count(LdapSearcherCache.Predicate<K> predicate) {
            int count = 0;
            LinkedHashMap linkedHashMap = this.theCache;
            synchronized (linkedHashMap) {
                for (Object current : this.theCache.keySet()) {
                    if (!predicate.matches(current)) continue;
                    ++count;
                }
            }
            return count;
        }

        @Override
        public Set<K> currentKeys() {
            return Collections.unmodifiableSet(this.theCache.keySet());
        }

        protected class CacheEntry {
            private volatile NamingException failure;
            private volatile LdapSearcherCache.SearchResult<R> result;
            private ScheduledFuture<?> future;

            protected CacheEntry() {
            }

            public LdapSearcherCache.SearchResult<R> getSearchResult(LdapConnectionHandler connectionHandler, K key) throws IOException, NamingException {
                if (this.failure != null) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Using cached failure for search with key '%s'", key);
                    throw this.failure;
                }
                if (this.result != null) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Using cached result for search with key '%s'", key);
                    return this.result;
                }
                CacheEntry cacheEntry = this;
                synchronized (cacheEntry) {
                    if (this.failure != null) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Using cached failure for search with key '%s'", key);
                        throw this.failure;
                    }
                    if (this.result != null) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Using cached result for search with key '%s'", key);
                        return this.result;
                    }
                    try {
                        Object result = LdapCacheService.this.internalSearch(connectionHandler, key);
                        DomainManagementLogger.SECURITY_LOGGER.tracef("New search for entry with key '%s'", key);
                        SearchResultImpl searchResult = new SearchResultImpl(result);
                        this.result = searchResult;
                        return this.result;
                    }
                    catch (NamingException e) {
                        if (BaseSearchCache.this.cacheFailures) {
                            this.failure = e;
                        }
                        throw e;
                    }
                }
            }

            public void setFuture(ScheduledFuture<?> future) {
                this.future = future;
            }

            public void cancelFuture() {
                if (this.future != null) {
                    this.future.cancel(true);
                }
            }
        }
    }

    private class NoCacheCache
    implements ExtendedLdapSearcherCache<R, K> {
        private NoCacheCache() {
        }

        @Override
        public LdapSearcherCache.SearchResult<R> search(LdapConnectionHandler connectionHandler, K key) throws IOException, NamingException {
            DomainManagementLogger.SECURITY_LOGGER.tracef("Non caching search for '%s'", key);
            Object result = LdapCacheService.this.searcher.search(connectionHandler, key);
            return new SearchResultImpl(result);
        }

        @Override
        public int getCurrentSize() {
            return 0;
        }

        @Override
        public void clearAll() {
        }

        @Override
        public void clear(K key) {
        }

        @Override
        public boolean contains(K key) {
            return false;
        }

        @Override
        public Set<K> currentKeys() {
            return Collections.emptySet();
        }

        @Override
        public void clear(LdapSearcherCache.Predicate<K> predicate) {
        }

        @Override
        public int count(LdapSearcherCache.Predicate<K> predicate) {
            return 0;
        }
    }

    private static interface ExtendedLdapSearcherCache<R, K>
    extends LdapSearcherCache<R, K> {
        @Override
        public int getCurrentSize();

        @Override
        public void clearAll();

        @Override
        public void clear(K var1);

        @Override
        public void clear(LdapSearcherCache.Predicate<K> var1);

        @Override
        public boolean contains(K var1);

        @Override
        public int count(LdapSearcherCache.Predicate<K> var1);

        public Set<K> currentKeys();
    }

    private static enum CacheMode {
        OFF,
        BY_SEARCH,
        BY_ACCESS;

    }
}

