/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.mgmt.ServerToHostProtocolHandler;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementPongRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class ServerToHostOperationHandlerFactoryService
implements ManagementChannelInitialization,
Service<ManagementChannelInitialization> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"management", "server", "to", "host", "controller"});
    private final ExecutorService executorService;
    private final InjectedValue<ServerInventory> serverInventory = new InjectedValue();
    private final ServerToHostProtocolHandler.OperationExecutor operationExecutor;
    private final DomainController domainController;
    private final ExpressionResolver expressionResolver;
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("server-registration-threads"), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    private volatile ExecutorService registrations;

    ServerToHostOperationHandlerFactoryService(ExecutorService executorService, ServerToHostProtocolHandler.OperationExecutor operationExecutor, DomainController domainController, ExpressionResolver expressionResolver) {
        this.executorService = executorService;
        this.operationExecutor = operationExecutor;
        this.domainController = domainController;
        this.expressionResolver = expressionResolver;
    }

    public static void install(ServiceTarget serviceTarget, ServiceName serverInventoryName, ExecutorService executorService, ServerToHostProtocolHandler.OperationExecutor operationExecutor, DomainController domainController, ExpressionResolver expressionResolver) {
        ServerToHostOperationHandlerFactoryService serverToHost = new ServerToHostOperationHandlerFactoryService(executorService, operationExecutor, domainController, expressionResolver);
        serviceTarget.addService(SERVICE_NAME, (Service)serverToHost).addDependency(serverInventoryName, ServerInventory.class, serverToHost.serverInventory).install();
    }

    public synchronized void start(StartContext context) throws StartException {
        this.registrations = Executors.newSingleThreadExecutor(this.threadFactory);
    }

    public synchronized void stop(StopContext context) {
        ExecutorService executorService = this.registrations;
        this.registrations = null;
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public synchronized ManagementChannelInitialization getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ManagementChannelHandler startReceiving(Channel channel) {
        ManagementChannelHandler channelHandler = new ManagementChannelHandler(channel, this.executorService);
        ServerToHostProtocolHandler registrationHandler = new ServerToHostProtocolHandler((ServerInventory)this.serverInventory.getValue(), this.operationExecutor, this.domainController, channelHandler, this.registrations, this.expressionResolver);
        channelHandler.addHandlerFactory((ManagementRequestHandlerFactory)new ManagementPongRequestHandler());
        channelHandler.addHandlerFactory((ManagementRequestHandlerFactory)registrationHandler);
        channel.receiveMessage(channelHandler.getReceiver());
        return channelHandler;
    }
}

