/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.sunday.unmarshalling.AbstractPosition;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.NonElementPosition;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceBinding
extends ModelGroupBinding {
    private List<ParticleBinding> choices = Collections.emptyList();

    public ChoiceBinding(SchemaBinding schema) {
        super(schema);
    }

    @Override
    public ElementBinding getArrayItem() {
        return null;
    }

    @Override
    public void addParticle(ParticleBinding particle) {
        switch (this.choices.size()) {
            case 0: {
                this.choices = Collections.singletonList(particle);
                break;
            }
            case 1: {
                this.choices = new ArrayList<ParticleBinding>(this.choices);
            }
            default: {
                this.choices.add(particle);
            }
        }
        super.addParticle(particle);
    }

    @Override
    public Collection<ParticleBinding> getParticles() {
        return this.choices;
    }

    @Override
    public AbstractPosition newPosition(QName qName, Attributes attrs, ParticleBinding choiceParticle) {
        for (int i = 0; i < this.choices.size(); ++i) {
            ParticleBinding particle = this.choices.get(i);
            AbstractPosition next = particle.getTerm().newPosition(qName, attrs, particle);
            if (next == null) continue;
            return new ChoicePosition(qName, choiceParticle, next);
        }
        return null;
    }

    @Override
    public String getGroupType() {
        return "choice";
    }

    private final class ChoicePosition
    extends NonElementPosition {
        private ChoicePosition(QName name, ParticleBinding particle, AbstractPosition next) {
            super(name, particle, next);
        }

        public AbstractPosition nextPosition(QName qName, Attributes atts) {
            if (trace) {
                StringBuffer sb = new StringBuffer();
                sb.append("startElement ").append(qName).append(" in ").append(ChoiceBinding.this.toString());
                log.trace((Object)sb.toString());
            }
            if (this.particle.isOccurrenceAllowed(this.occurrence + 1)) {
                for (int i = 0; i < ChoiceBinding.this.choices.size(); ++i) {
                    ParticleBinding choice = (ParticleBinding)ChoiceBinding.this.choices.get(i);
                    TermBinding term = choice.getTerm();
                    this.next = term.newPosition(qName, atts, choice);
                    if (this.next == null) continue;
                    this.next.previous = this;
                    ++this.occurrence;
                    if (!this.skip) {
                        this.o = this.handler.endParticle(this.o, qName, this.particle);
                        if (this.previous.o != null) {
                            this.setParent(this.previous, this.handler);
                        }
                        this.initValue(atts);
                    }
                    if (trace) {
                        log.trace((Object)("found " + qName + " in " + ChoiceBinding.this + ", term=" + choice.getTerm()));
                    }
                    return this;
                }
            }
            this.nextNotFound();
            return null;
        }
    }
}

