/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.validator;

import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.validator.SubjectStatementSchemaValidator;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;

public class AuthenticationStatementSchemaValidator
extends SubjectStatementSchemaValidator<AuthenticationStatement> {
    @Override
    public void validate(AuthenticationStatement authenticationStatement) throws ValidationException {
        super.validate(authenticationStatement);
        this.validateAuthenticationMethod(authenticationStatement);
        this.validateAuthenticationInstant(authenticationStatement);
    }

    protected void validateAuthenticationMethod(AuthenticationStatement authenticationStatement) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)authenticationStatement.getAuthenticationMethod())) {
            throw new ValidationException("No authenticationStatement URI is null");
        }
    }

    protected void validateAuthenticationInstant(AuthenticationStatement authenticationStatement) throws ValidationException {
        if (authenticationStatement.getAuthenticationInstant() == null) {
            throw new ValidationException("No authenticationInstant present");
        }
    }
}

