/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.invoker.BatchCacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.CacheServiceProvider;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceProvider;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.group.CacheGroupProvider;
import org.wildfly.clustering.server.group.CacheNodeFactory;
import org.wildfly.clustering.server.group.CacheNodeFactoryProvider;
import org.wildfly.clustering.server.registry.RegistryFactoryConfiguration;
import org.wildfly.clustering.server.registry.RegistryFactoryService;
import org.wildfly.clustering.server.registry.RegistryService;

public class RegistryFactoryProvider
implements CacheServiceProvider {
    private static final Logger logger = Logger.getLogger(ChannelServiceProvider.class);

    public static ServiceName getServiceName(String containerName, String cacheName) {
        return ServiceName.JBOSS.append(new String[]{"clustering", "registry", containerName, cacheName});
    }

    public static ServiceName getFactoryServiceName(String containerName, String cacheName) {
        return RegistryFactoryProvider.getServiceName(containerName, cacheName).append(new String[]{"factory"});
    }

    public static ServiceName getEntryProviderServiceName(String containerName, String cacheName) {
        return RegistryFactoryProvider.getServiceName(containerName, cacheName).append(new String[]{"entry"});
    }

    private static ContextNames.BindInfo createBinding(String containerName, String cacheName) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "registry", containerName, cacheName}).getAbsoluteName());
    }

    public Collection<ServiceName> getServiceNames(String containerName, String cacheName, boolean defaultCache) {
        ArrayList<ServiceName> result = new ArrayList<ServiceName>(4);
        result.add(RegistryFactoryProvider.getServiceName(containerName, cacheName));
        result.add(RegistryFactoryProvider.getFactoryServiceName(containerName, cacheName));
        result.add(RegistryFactoryProvider.createBinding(containerName, cacheName).getBinderServiceName());
        if (defaultCache && !cacheName.equals("default")) {
            result.add(RegistryFactoryProvider.getServiceName(containerName, "default"));
        }
        return result;
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String containerName, String cacheName, boolean defaultCache, ModuleIdentifier moduleId) {
        boolean addDefaultCacheAlias;
        ServiceName name = RegistryFactoryProvider.getFactoryServiceName(containerName, cacheName);
        ContextNames.BindInfo bindInfo = RegistryFactoryProvider.createBinding(containerName, cacheName);
        logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        RegistryFactoryConfig registryConfig = new RegistryFactoryConfig();
        RegistryFactoryService registryService = new RegistryFactoryService(registryConfig);
        ServiceBuilder factoryBuilder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)name, registryService).addDependency(CacheNodeFactoryProvider.getServiceName(containerName, cacheName), CacheNodeFactory.class, registryConfig.getNodeFactoryInjector()).addDependency(CacheGroupProvider.getServiceName(containerName, cacheName), Group.class, registryConfig.getGroupInjector()).addDependency(CacheService.getServiceName((String)containerName, (String)cacheName), Cache.class, registryConfig.getCacheInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        ServiceBuilder builder = RegistryService.build(target, containerName, cacheName).setInitialMode(ServiceController.Mode.ON_DEMAND);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{bindInfo.getBindName()})}).addDependency(name, RegistryFactory.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        boolean bl = addDefaultCacheAlias = defaultCache && !cacheName.equals("default");
        if (addDefaultCacheAlias) {
            ContextNames.BindInfo info = RegistryFactoryProvider.createBinding(containerName, "default");
            binderBuilder.addAliases(new ServiceName[]{info.getBinderServiceName(), ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{info.getBindName()})});
            factoryBuilder.addAliases(new ServiceName[]{RegistryFactoryProvider.getFactoryServiceName(containerName, "default")});
        }
        ArrayList result = new ArrayList(4);
        result.add(builder.install());
        result.add(factoryBuilder.install());
        result.add(binderBuilder.install());
        if (addDefaultCacheAlias) {
            ServiceBuilder defaultBuilder = RegistryService.build(target, containerName, "default").setInitialMode(ServiceController.Mode.ON_DEMAND);
            result.add(defaultBuilder.install());
        }
        return result;
    }

    static class RegistryFactoryConfig<K, V>
    implements RegistryFactoryConfiguration<K, V> {
        private final CacheInvoker invoker = new BatchCacheInvoker();
        private final InjectedValue<Group> group = new InjectedValue();
        private final InjectedValue<Cache<Node, Map.Entry<K, V>>> cache = new InjectedValue();
        private final InjectedValue<CacheNodeFactory> factory = new InjectedValue();

        RegistryFactoryConfig() {
        }

        @Override
        public CacheInvoker getCacheInvoker() {
            return this.invoker;
        }

        @Override
        public Group getGroup() {
            return (Group)this.group.getValue();
        }

        @Override
        public Cache<Node, Map.Entry<K, V>> getCache() {
            return (Cache)this.cache.getValue();
        }

        @Override
        public NodeFactory<Address> getNodeFactory() {
            return (NodeFactory)this.factory.getValue();
        }

        Injector<Group> getGroupInjector() {
            return this.group;
        }

        Injector<Cache> getCacheInjector() {
            return this.cache;
        }

        Injector<CacheNodeFactory> getNodeFactoryInjector() {
            return this.factory;
        }
    }
}

