/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.concurrent.handle.ContextHandle;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;

public class TransactionLeakContextHandleFactory
implements ContextHandleFactory,
Injector<TransactionManager> {
    public static final String NAME = "TRANSACTION_LEAK";
    private TransactionManager transactionManager;

    @Override
    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new TransactionLeakContextHandle(this.transactionManager);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getChainPriority() {
        return 600;
    }

    @Override
    public void writeHandle(ContextHandle contextHandle, ObjectOutputStream out) throws IOException {
    }

    @Override
    public ContextHandle readHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return new TransactionLeakContextHandle(this.transactionManager);
    }

    public void inject(TransactionManager value) throws InjectionException {
        this.transactionManager = value;
    }

    public void uninject() {
        this.transactionManager = null;
    }

    private static class TransactionLeakContextHandle
    implements ContextHandle {
        private final TransactionManager transactionManager;
        private Transaction transactionOnSetup;

        private TransactionLeakContextHandle(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        @Override
        public void setup() throws IllegalStateException {
            if (this.transactionManager != null) {
                try {
                    this.transactionOnSetup = this.transactionManager.getTransaction();
                }
                catch (SystemException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void reset() {
            block16: {
                if (this.transactionManager != null) {
                    try {
                        Transaction transactionOnReset = this.transactionManager.getTransaction();
                        if (transactionOnReset == null || transactionOnReset.equals(this.transactionOnSetup)) break block16;
                        switch (transactionOnReset.getStatus()) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 7: 
                            case 8: 
                            case 9: {
                                EeLogger.ROOT_LOGGER.rollbackOfTransactionStartedInEEConcurrentInvocation();
                                this.transactionManager.rollback();
                                try {
                                    this.transactionManager.suspend();
                                }
                                catch (Throwable e) {
                                    EeLogger.ROOT_LOGGER.failedToSuspendTransaction(e);
                                }
                                break;
                                catch (Throwable e) {
                                    try {
                                        EeLogger.ROOT_LOGGER.failedToRollbackTransaction(e);
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            this.transactionManager.suspend();
                                        }
                                        catch (Throwable e2) {
                                            EeLogger.ROOT_LOGGER.failedToSuspendTransaction(e2);
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        this.transactionManager.suspend();
                                    }
                                    catch (Throwable e3) {
                                        EeLogger.ROOT_LOGGER.failedToSuspendTransaction(e3);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    catch (SystemException e) {
                        EeLogger.ROOT_LOGGER.systemErrorWhileCheckingForTransactionLeak(e);
                    }
                }
            }
        }

        @Override
        public String getFactoryName() {
            return TransactionLeakContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeMessages.MESSAGES.serializationMustBeHandledByThefactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeMessages.MESSAGES.serializationMustBeHandledByThefactory();
        }
    }
}

