/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.websocket.OpHandler;
import org.infinispan.server.websocket.WebSocketServer;
import org.infinispan.server.websocket.json.JsonConversionException;
import org.infinispan.server.websocket.json.JsonObject;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String INFINISPAN_WS_JS_FILENAME = "infinispan-ws.js";
    private CacheContainer cacheContainer;
    private Map<String, OpHandler> operationHandlers;
    private boolean connectionUpgraded;
    private final Map<String, Cache<Object, Object>> startedCaches;
    private WebSocketServerHandshaker handshaker;

    public WebSocketServerHandler(CacheContainer cacheContainer, Map<String, OpHandler> operationHandlers, Map<String, Cache<Object, Object>> startedCaches) {
        this.cacheContainer = cacheContainer;
        this.operationHandlers = operationHandlers;
        this.startedCaches = startedCaches;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (req.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, Unpooled.EMPTY_BUFFER));
            return;
        }
        if (!this.connectionUpgraded && req.getUri().equalsIgnoreCase("/infinispan-ws.js")) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            this.loadScriptToResponse(req, res);
            this.sendHttpResponse(ctx, req, (FullHttpResponse)res);
        } else {
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation((HttpRequest)req), null, false);
            this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
            if (this.handshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                this.handshaker.handshake(ctx.channel(), req).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            future.channel().pipeline().fireExceptionCaught(future.cause());
                        } else {
                            WebSocketServerHandler.this.connectionUpgraded = true;
                        }
                    }
                });
            }
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
        } else if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), ((CloseWebSocketFrame)frame).retain());
        } else {
            try {
                ByteBuf binaryData = frame.content();
                if (binaryData == null) {
                    return;
                }
                JsonObject payload = JsonObject.fromString(binaryData.toString(CharsetUtil.UTF_8));
                String opCode = (String)payload.get("opCode");
                String cacheName = (String)payload.get("cacheName");
                Cache<Object, Object> cache = this.getCache(cacheName);
                OpHandler handler = this.operationHandlers.get(opCode);
                if (handler != null) {
                    handler.handleOp(payload, cache, ctx);
                }
            }
            catch (JsonConversionException e) {
                log.error((Object)"Could not handle Web Socket Frame, error while converting to JSON", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<Object, Object> getCache(String cacheName) {
        Cache cache;
        String key = cacheName;
        if (key == null) {
            key = "";
        }
        if ((cache = this.startedCaches.get(key)) == null) {
            Map<String, Cache<Object, Object>> map = this.startedCaches;
            synchronized (map) {
                cache = this.startedCaches.get(key);
                if (cache == null) {
                    cache = cacheName != null ? this.cacheContainer.getCache(key) : this.cacheContainer.getCache();
                    this.startedCaches.put(key, (Cache<Object, Object>)cache);
                    cache.start();
                }
            }
        }
        return cache;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        if (res.getStatus().code() != 200) {
            res.content().writeBytes(res.getStatus().toString().getBytes(CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void loadScriptToResponse(FullHttpRequest req, DefaultFullHttpResponse res) {
        String wsAddress = this.getWebSocketLocation((HttpRequest)req);
        StringWriter writer = new StringWriter();
        writer.write("var defaultWSAddress = '" + wsAddress + "';");
        writer.write(WebSocketServer.getJavascript());
        ByteBuf content = res.content().writeBytes(writer.toString().getBytes(CharsetUtil.UTF_8));
        res.headers().set("Content-Type", (Object)"text/javascript; charset=UTF-8");
        HttpHeaders.setContentLength((HttpMessage)res, (long)content.readableBytes());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.headers().get("Host") + "/";
    }
}

