/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.FlushMode;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.CapacityDecrementer;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.connectionmanager.pool.capacity.DefaultCapacity;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;
import org.jboss.jca.core.connectionmanager.pool.mcp.CapacityFiller;
import org.jboss.jca.core.connectionmanager.pool.mcp.CapacityRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.FillRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatistics;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatisticsImpl;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolUtility;
import org.jboss.jca.core.connectionmanager.pool.mcp.PoolFiller;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;
import org.jboss.logging.Messages;

public class ArrayBlockingQueueManagedConnectionPool
implements ManagedConnectionPool {
    private CoreLogger log;
    private boolean debug;
    private boolean trace;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Subject defaultSubject;
    private ConnectionRequestInfo defaultCri;
    private PoolConfiguration poolConfiguration;
    private Pool pool;
    private ArrayBlockingQueue<ConnectionListener> cls;
    private ConcurrentSkipListSet<ConnectionListener> checkedOut;
    private ManagedConnectionPoolStatisticsImpl statistics;
    private Boolean supportsLazyAssociation;
    private long lastIdleCheck;
    private long lastUsed;

    @Override
    public void initialize(ManagedConnectionFactory mcf, ConnectionManager cm, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) {
        if (mcf == null) {
            throw new IllegalArgumentException("ManagedConnectionFactory is null");
        }
        if (cm == null) {
            throw new IllegalArgumentException("ConnectionManager is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        this.mcf = mcf;
        this.cm = cm;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolConfiguration = pc;
        this.pool = p;
        this.log = this.pool.getLogger();
        this.debug = this.log.isDebugEnabled();
        this.trace = this.log.isTraceEnabled();
        this.cls = new ArrayBlockingQueue(pc.getMaxSize(), true);
        this.checkedOut = new ConcurrentSkipListSet();
        this.statistics = new ManagedConnectionPoolStatisticsImpl(pc.getMaxSize());
        this.statistics.setEnabled(p.getStatistics().isEnabled());
        this.supportsLazyAssociation = null;
        this.lastIdleCheck = Long.MIN_VALUE;
        this.lastUsed = Long.MAX_VALUE;
        if ((pc.isPrefill() || pc.isStrictMin()) && p instanceof PrefillPool && pc.getInitialSize() > 0) {
            PoolFiller.fillPool(new FillRequest(this, pc.getInitialSize()));
        }
        this.reenable();
        this.statistics.setMaxWaitCount(-1);
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public boolean isRunning() {
        return !this.pool.isShutdown();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.cls.size() == 0 && this.checkedOut.size() == 0;
    }

    @Override
    public synchronized boolean isFull() {
        return this.checkedOut.size() == this.poolConfiguration.getMaxSize();
    }

    @Override
    public synchronized boolean isIdle() {
        return this.checkedOut.size() == 0;
    }

    @Override
    public synchronized int getActive() {
        return this.cls.size() + this.checkedOut.size();
    }

    @Override
    public void reenable() {
        if (this.poolConfiguration.getIdleTimeoutMinutes() > 0) {
            IdleRemover.getInstance().registerPool(this, (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L);
        }
        if (this.poolConfiguration.isBackgroundValidation() && this.poolConfiguration.getBackgroundValidationMillis() > 0L) {
            this.log.debug("Registering for background validation at interval " + this.poolConfiguration.getBackgroundValidationMillis());
            ConnectionValidator.getInstance().registerPool(this, this.poolConfiguration.getBackgroundValidationMillis());
        }
    }

    @Override
    public void prefill() {
        if (this.isRunning() && (this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool && this.poolConfiguration.getMinSize() > 0) {
            PoolFiller.fillPool(new FillRequest(this, this.poolConfiguration.getMinSize()));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (this.trace) {
            method = "getConnection(" + subject + ", " + cri + ")";
            this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
        } else if (this.debug) {
            method = "getConnection(" + subject + ", " + cri + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.poolConfiguration.getMaxSize()));
        }
        subject = subject == null ? this.defaultSubject : subject;
        cri = cri == null ? this.defaultCri : cri;
        cl = null;
        verifyConnectionListener = true;
        v0 = startWait = this.statistics.isEnabled() != false ? System.currentTimeMillis() : 0L;
        if (this.isFull()) {
            this.statistics.deltaWaitCount();
        }
        if (this.cls.size() > 0) {
            if (!this.isRunning()) {
                throw new ResourceException(ArrayBlockingQueueManagedConnectionPool.bundle.thePoolHasBeenShutdown(this.pool.getName(), Integer.toHexString(System.identityHashCode(this))));
            }
            cl = this.cls.peek();
            if (cl != null) {
                try {
                    cl = this.cls.poll(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS);
                    if (!this.statistics.isEnabled()) ** GOTO lbl88
                    this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                    end = this.statistics.isEnabled() != false ? System.currentTimeMillis() - startWait : 0L;
                    throw new ResourceException(ArrayBlockingQueueManagedConnectionPool.bundle.interruptedWhileRequestingConnection(end));
                }
            } else {
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    if (this.trace) {
                        this.log.trace("supplying new ManagedConnection: " + cl);
                    }
                    if (this.pool.getCapacity().getIncrementer() != null) {
                        CapacityFiller.schedule(new CapacityRequest(this, subject, cri));
                    }
                    verifyConnectionListener = false;
                }
                catch (Throwable t) {
                    if (cl != null || !(t instanceof RetryableException)) {
                        this.log.throwableWhileAttemptingGetNewGonnection(cl, t);
                    }
                    if (cl != null) {
                        this.doDestroy(cl);
                    }
                    if (t instanceof ResourceException) {
                        throw (ResourceException)t;
                    }
                    throw new ResourceException(ArrayBlockingQueueManagedConnectionPool.bundle.unexpectedThrowableWhileTryingCreateConnection(cl), t);
                }
            }
        } else {
            if (this.isFull()) {
                this.statistics.deltaWaitCount();
                if (this.pool.isSharable() && (this.supportsLazyAssociation == null || this.supportsLazyAssociation.booleanValue())) {
                    if (this.supportsLazyAssociation == null) {
                        this.checkLazyAssociation();
                    }
                    if (this.supportsLazyAssociation != null && this.supportsLazyAssociation.booleanValue()) {
                        if (this.trace) {
                            this.log.tracef("Trying to detach - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
                        }
                        if (!this.detachConnectionListener() && this.trace) {
                            this.log.tracef("Detaching didn't succeed - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
                        }
                    }
                }
            }
            try {
                cl = this.cls.poll(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS);
                if (!this.isRunning()) {
                    throw new ResourceException(ArrayBlockingQueueManagedConnectionPool.bundle.thePoolHasBeenShutdown(this.pool.getName(), Integer.toHexString(System.identityHashCode(this))));
                }
                if (cl == null) {
                    this.statistics.deltaBlockingFailureCount();
                    throw new ResourceException(ArrayBlockingQueueManagedConnectionPool.bundle.noMManagedConnectionsAvailableWithinConfiguredBlockingTimeout(this.poolConfiguration.getBlockingTimeout()));
                }
                if (this.statistics.isEnabled()) {
                    this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                if (!this.poolConfiguration.isUseFastFail()) {
                    this.statistics.deltaBlockingFailureCount();
                    throw new ResourceException(ArrayBlockingQueueManagedConnectionPool.bundle.noMManagedConnectionsAvailableWithinConfiguredBlockingTimeout(this.poolConfiguration.getBlockingTimeout()));
                }
                if (this.trace) {
                    this.log.trace("Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                }
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    this.prefill();
                    if (this.pool.getCapacity().getIncrementer() != null) {
                        CapacityFiller.schedule(new CapacityRequest(this, subject, cri));
                    }
                    if (this.trace) {
                        this.log.trace("supplying new ManagedConnection: " + cl);
                    }
                    verifyConnectionListener = false;
                }
                catch (Throwable t) {
                    this.log.throwableWhileAttemptingGetNewGonnection(cl, t);
                    if (cl != null) {
                        this.doDestroy(cl);
                    }
                    throw new ResourceException(ArrayBlockingQueueManagedConnectionPool.bundle.unexpectedThrowableWhileTryingCreateConnection(cl), t);
                }
            }
        }
lbl88:
        // 5 sources

        this.checkedOut.add(cl);
        if (this.statistics.isEnabled()) {
            this.statistics.setInUsedCount(this.checkedOut.size());
        }
        if (!verifyConnectionListener) {
            this.lastUsed = System.currentTimeMillis();
            if (this.statistics.isEnabled()) {
                this.statistics.deltaTotalGetTime(this.lastUsed - startWait);
            }
            return cl;
        }
        try {
            matchedMC = this.mcf.matchManagedConnections(Collections.singleton(cl.getManagedConnection()), subject, cri);
            if (matchedMC != null) {
                if (this.trace) {
                    this.log.trace("supplying ManagedConnection from pool: " + cl);
                }
                this.lastUsed = System.currentTimeMillis();
                if (this.statistics.isEnabled()) {
                    this.statistics.deltaTotalGetTime(this.lastUsed - startWait);
                }
                return cl;
            }
            this.log.destroyingConnectionNotSuccessfullyMatched(cl, this.mcf);
            this.checkedOut.remove(cl);
            if (this.statistics.isEnabled()) {
                this.statistics.setInUsedCount(this.checkedOut.size());
            }
            this.doDestroy(cl);
            cl = null;
        }
        catch (Throwable t) {
            this.log.throwableWhileTryingMatchManagedConnection(cl, t);
            this.checkedOut.remove(cl);
            if (this.statistics.isEnabled()) {
                this.statistics.setInUsedCount(this.checkedOut.size());
            }
            this.doDestroy(cl);
            cl = null;
            throw new ResourceException(ArrayBlockingQueueManagedConnectionPool.bundle.unexpectedThrowableWhileTryingCreateConnection(cl), t);
        }
        throw new ResourceException(ArrayBlockingQueueManagedConnectionPool.bundle.shouldNeverHappen(), new Throwable("STACKTRACE"));
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc) {
        return this.findConnectionListener(mc, null);
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc, Object connection) {
        for (ConnectionListener cl : this.checkedOut) {
            if (!cl.controls(mc, connection)) continue;
            return cl;
        }
        return null;
    }

    @Override
    public void addConnectionListener(ConnectionListener cl) {
        try {
            this.cls.put(cl);
            if (this.statistics.isEnabled()) {
                this.statistics.deltaCreatedCount();
            }
        }
        catch (Throwable t) {
            Thread.interrupted();
            cl.setState(ConnectionState.DESTROY);
            this.doDestroy(cl);
        }
    }

    @Override
    public ConnectionListener removeConnectionListener() {
        ConnectionListener cl = this.cls.poll();
        if (cl != null && this.statistics.isEnabled()) {
            this.statistics.deltaDestroyedCount();
        }
        return cl;
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) {
        this.returnConnection(cl, kill, true);
    }

    public void returnConnection(ConnectionListener cl, boolean kill, boolean cleanup) {
        String method;
        if (this.trace) {
            method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
            this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
        } else if (this.debug) {
            method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.poolConfiguration.getMaxSize()));
        }
        if (cl.getState() == ConnectionState.DESTROYED) {
            if (this.trace) {
                this.log.trace("ManagedConnection is being returned after it was destroyed" + cl);
            }
            return;
        }
        if (cleanup) {
            try {
                cl.getManagedConnection().cleanup();
            }
            catch (ResourceException re) {
                this.log.resourceExceptionCleaningUpManagedConnection(cl, re);
                kill = true;
            }
        }
        if (cl.getState() == ConnectionState.DESTROY || cl.getState() == ConnectionState.DESTROYED) {
            kill = true;
        }
        this.checkedOut.remove(cl);
        if (this.statistics.isEnabled()) {
            this.statistics.setInUsedCount(this.checkedOut.size());
        }
        if (!kill && this.cls.size() >= this.poolConfiguration.getMaxSize()) {
            this.log.destroyingReturnedConnectionMaximumPoolSizeExceeded(cl);
            kill = true;
        }
        if (kill) {
            this.cls.remove(cl);
        } else {
            cl.used();
            if (!this.cls.contains(cl)) {
                try {
                    this.cls.put(cl);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                    cl.setState(ConnectionState.DESTROY);
                    kill = true;
                }
            } else {
                this.log.attemptReturnConnectionTwice(cl, new Throwable("STACKTRACE"));
            }
        }
        if (kill) {
            if (this.trace) {
                this.log.trace("Destroying returned connection " + cl);
            }
            this.doDestroy(cl);
            cl = null;
        }
    }

    @Override
    public void flush(FlushMode mode) {
        ConnectionListener cl;
        ArrayList<ConnectionListener> keep = null;
        ArrayList<ConnectionListener> destroy = null;
        if (this.trace) {
            this.log.trace("Flushing pool checkedOut=" + this.checkedOut + " inPool=" + this.cls);
        }
        if (FlushMode.ALL == mode) {
            while (this.checkedOut.size() > 0) {
                cl = this.checkedOut.pollFirst();
                if (this.trace) {
                    this.log.trace("Flush marking checked out connection for destruction " + cl);
                }
                cl.setState(ConnectionState.DESTROY);
                if (destroy == null) {
                    destroy = new ArrayList<ConnectionListener>(1);
                }
                destroy.add(cl);
            }
        } else if (FlushMode.GRACEFULLY == mode) {
            if (this.trace) {
                this.log.trace("Gracefully flushing pool checkedOut=" + this.checkedOut + " inPool=" + this.cls);
            }
            for (ConnectionListener cl2 : this.checkedOut) {
                if (this.trace) {
                    this.log.trace("Graceful flush marking checked out connection for destruction " + cl2);
                }
                cl2.setState(ConnectionState.DESTROY);
            }
        }
        cl = this.cls.poll();
        while (cl != null) {
            boolean kill = true;
            if (FlushMode.INVALID == mode && this.mcf instanceof ValidatingManagedConnectionFactory) {
                try {
                    ValidatingManagedConnectionFactory vcf = (ValidatingManagedConnectionFactory)this.mcf;
                    Set candidateSet = Collections.singleton(cl.getManagedConnection());
                    candidateSet = vcf.getInvalidConnections(candidateSet);
                    if (candidateSet == null || candidateSet.size() == 0) {
                        kill = false;
                    }
                }
                catch (Throwable t) {
                    this.log.trace("Exception during invalid flush", t);
                }
            }
            if (kill) {
                if (destroy == null) {
                    destroy = new ArrayList(1);
                }
                cl.setState(ConnectionState.DESTROY);
                destroy.add(cl);
            } else {
                if (keep == null) {
                    keep = new ArrayList<ConnectionListener>(1);
                }
                keep.add(cl);
            }
            cl = this.cls.poll();
        }
        if (keep != null) {
            while (keep.size() > 0) {
                cl = (ConnectionListener)keep.remove(0);
                if (this.cls.offer(cl)) continue;
                if (destroy == null) {
                    destroy = new ArrayList(1);
                }
                destroy.add(cl);
            }
        }
        if (destroy != null) {
            for (ConnectionListener destroyCl : destroy) {
                if (this.trace) {
                    this.log.trace("Destroying flushed connection " + destroyCl);
                }
                this.doDestroy(destroyCl);
                destroyCl = null;
            }
        }
        this.prefill();
    }

    @Override
    public void removeIdleConnections() {
        long timeoutSetting;
        long now = System.currentTimeMillis();
        if (now < this.lastIdleCheck + (timeoutSetting = (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L)) {
            return;
        }
        if (this.trace) {
            this.log.tracef("Idle check - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
        }
        this.lastIdleCheck = now;
        ArrayList<ConnectionListener> destroyConnections = null;
        long timeout = now - timeoutSetting;
        CapacityDecrementer decrementer = this.pool.getCapacity().getDecrementer();
        boolean destroy = true;
        int destroyed = 0;
        if (decrementer == null) {
            decrementer = DefaultCapacity.DEFAULT_DECREMENTER;
        }
        while (destroy) {
            ConnectionListener cl = this.cls.peek();
            if (cl != null) {
                destroy = decrementer.shouldDestroy(cl, timeout, this.cls.size() + this.checkedOut.size(), this.poolConfiguration.getMinSize(), destroyed);
                if (!destroy) continue;
                if (this.shouldRemove()) {
                    if (this.statistics.isEnabled()) {
                        this.statistics.deltaTimedOut();
                    }
                    if (destroyConnections == null) {
                        destroyConnections = new ArrayList<ConnectionListener>(1);
                    }
                    if ((cl = this.cls.poll()) != null) {
                        if (this.trace) {
                            this.log.trace("Idle connection cl=" + cl);
                        }
                        destroyConnections.add(cl);
                        ++destroyed;
                        continue;
                    }
                    destroy = false;
                    continue;
                }
                destroy = false;
                continue;
            }
            destroy = false;
        }
        if (destroyConnections != null) {
            for (ConnectionListener cl : destroyConnections) {
                if (this.trace) {
                    this.log.trace("Destroying timedout connection " + cl);
                }
                this.doDestroy(cl);
                cl = null;
            }
            if (this.isRunning()) {
                boolean emptyManagedConnectionPool = false;
                if ((this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
                    if (this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(new FillRequest(this, this.poolConfiguration.getMinSize()));
                    } else {
                        emptyManagedConnectionPool = true;
                    }
                } else {
                    emptyManagedConnectionPool = true;
                }
                if (emptyManagedConnectionPool && this.isEmpty()) {
                    this.pool.emptyManagedConnectionPool(this);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.trace) {
            this.log.tracef("Shutdown - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
        }
        IdleRemover.getInstance().unregisterPool(this);
        ConnectionValidator.getInstance().unregisterPool(this);
        if (this.checkedOut.size() > 0) {
            for (ConnectionListener cl : this.checkedOut) {
                this.log.destroyingActiveConnection(this.pool.getName(), cl.getManagedConnection());
            }
        }
        this.flush(FlushMode.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillTo(int size) {
        if (size <= 0) {
            return;
        }
        if (!this.poolConfiguration.isPrefill() && !this.poolConfiguration.isStrictMin()) {
            return;
        }
        if (!(this.pool instanceof PrefillPool)) {
            return;
        }
        while (size - (this.cls.size() + this.checkedOut.size()) > 0) {
            if (!this.isRunning()) {
                if (this.statistics.isEnabled()) {
                    this.statistics.setInUsedCount(this.checkedOut.size());
                }
                return;
            }
            ConnectionListener cl = null;
            boolean destroy = false;
            try {
                cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                if (this.statistics.isEnabled()) {
                    this.statistics.setInUsedCount(this.checkedOut.size() + 1);
                }
                if (this.checkedOut.size() + this.cls.size() < size) {
                    if (this.trace) {
                        this.log.trace("Filling pool cl=" + cl);
                    }
                    if (this.cls.offer(cl)) continue;
                    this.log.debug("Connection couldn't be inserted during fillTo");
                    destroy = true;
                    continue;
                }
                this.log.debug("Size reached during fillTo");
                destroy = true;
            }
            catch (ResourceException re) {
                this.log.unableFillPool(re);
                destroy = true;
            }
            finally {
                if (!destroy) continue;
                if (cl == null) break;
                this.doDestroy(cl);
                cl = null;
                break;
            }
        }
        if (this.statistics.isEnabled()) {
            this.statistics.setInUsedCount(this.checkedOut.size());
        }
    }

    @Override
    public ManagedConnectionPoolStatistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseCapacity(Subject subject, ConnectionRequestInfo cri) {
        int created = 1;
        boolean create = true;
        while (create && !this.isFull()) {
            if (!this.isRunning()) {
                if (this.statistics.isEnabled()) {
                    this.statistics.setInUsedCount(this.checkedOut.size());
                }
                return;
            }
            create = this.pool.getCapacity().getIncrementer().shouldCreate(this.cls.size() + this.checkedOut.size(), this.poolConfiguration.getMaxSize(), created);
            if (!create) continue;
            ConnectionListener cl = null;
            boolean destroy = false;
            try {
                cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                if (this.statistics.isEnabled()) {
                    this.statistics.setInUsedCount(this.checkedOut.size() + 1);
                }
                if (!this.cls.offer(cl)) {
                    this.log.debug("Connection couldn't be inserted during increaseCapacity");
                    destroy = true;
                    continue;
                }
                if (this.trace) {
                    this.log.trace("Capacity fill: cl=" + cl);
                }
                ++created;
            }
            catch (ResourceException re) {
                this.log.unableFillPool(re);
                destroy = true;
            }
            finally {
                if (!destroy || cl == null) continue;
                this.doDestroy(cl);
                cl = null;
            }
        }
        if (this.statistics.isEnabled()) {
            this.statistics.setInUsedCount(this.checkedOut.size());
        }
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        long start = this.statistics.isEnabled() ? System.currentTimeMillis() : 0L;
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        if (this.statistics.isEnabled()) {
            this.statistics.deltaTotalCreationTime(System.currentTimeMillis() - start);
            this.statistics.deltaCreatedCount();
        }
        try {
            return this.cm.createConnectionListener(mc, this);
        }
        catch (ResourceException re) {
            if (this.statistics.isEnabled()) {
                this.statistics.deltaDestroyedCount();
            }
            mc.destroy();
            throw re;
        }
    }

    private void doDestroy(ConnectionListener cl) {
        if (cl.getState() == ConnectionState.DESTROYED) {
            this.log.trace("ManagedConnection is already destroyed " + cl);
            return;
        }
        if (this.statistics.isEnabled()) {
            this.statistics.deltaDestroyedCount();
        }
        cl.setState(ConnectionState.DESTROYED);
        ManagedConnection mc = cl.getManagedConnection();
        try {
            mc.destroy();
        }
        catch (Throwable t) {
            this.log.debug("Exception destroying ManagedConnection " + cl, t);
        }
        mc.removeConnectionEventListener((ConnectionEventListener)cl);
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolConfiguration.isStrictMin() && this.pool instanceof PrefillPool) {
            boolean bl = remove = this.cls.size() > this.poolConfiguration.getMinSize();
            if (this.trace) {
                this.log.trace("StrictMin is active. Current connection will be removed is " + remove);
            }
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void validateConnections() throws Exception {
        block21: {
            if (this.trace) {
                this.log.trace("Attempting to  validate connections for pool " + this);
            }
            if (this.trace) {
                var1_1 = this.cls;
                synchronized (var1_1) {
                    method = "validateConnections()";
                    this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
                }
            } else if (this.debug) {
                method = "validateConnections()";
                this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.poolConfiguration.getMaxSize()));
            }
            anyDestroyed = false;
            while (true) lbl-1000:
            // 6 sources

            {
                cl = null;
                destroyed = false;
                if (this.cls.size() == 0) {
                    break block21;
                }
                cl = this.removeForFrequencyCheck();
                if (cl == null) {
                    break block21;
                }
                try {
                    candidateSet = Collections.singleton(cl.getManagedConnection());
                    if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                        vcf = (ValidatingManagedConnectionFactory)this.mcf;
                        if ((candidateSet = vcf.getInvalidConnections(candidateSet)) == null || candidateSet.size() <= 0 || cl.getState() == ConnectionState.DESTROY) ** GOTO lbl-1000
                        this.doDestroy(cl);
                        cl = null;
                        destroyed = true;
                        anyDestroyed = true;
                    }
                    this.log.backgroundValidationNonCompliantManagedConnectionFactory();
                }
                catch (ResourceException re) {
                    if (cl != null) {
                        this.doDestroy(cl);
                        cl = null;
                        destroyed = true;
                        anyDestroyed = true;
                    }
                    this.log.connectionValidatorIgnoredUnexpectedError(re);
                }
                finally {
                    if (destroyed || this.returnForFrequencyCheck(cl)) continue;
                    anyDestroyed = true;
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (anyDestroyed) {
                    this.prefill();
                }
            }
        }
    }

    private ConnectionListener removeForFrequencyCheck() {
        ConnectionListener result = null;
        Iterator<ConnectionListener> iter = this.cls.iterator();
        while (result == null && iter.hasNext()) {
            ConnectionListener cl = iter.next();
            long lastCheck = cl.getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck < this.poolConfiguration.getBackgroundValidationMillis()) continue;
            result = cl;
            this.cls.remove(cl);
        }
        this.log.debugf("Checking for connection within frequency: %s", result);
        return result;
    }

    private boolean returnForFrequencyCheck(ConnectionListener cl) {
        this.log.debugf("Returning for connection within frequency: %s", cl);
        if (cl == null) {
            return true;
        }
        cl.setLastValidatedTime(System.currentTimeMillis());
        if (!this.cls.offer(cl)) {
            this.log.debug("Connection couldn't be returned");
            this.doDestroy(cl);
            cl = null;
            return false;
        }
        return true;
    }

    private void checkLazyAssociation() {
        ConnectionListener cl = null;
        if (this.checkedOut.size() > 0) {
            cl = this.checkedOut.first();
        }
        if (cl == null && this.cls.size() > 0) {
            cl = this.cls.peek();
        }
        if (cl != null) {
            if (cl.supportsLazyAssociation()) {
                if (this.debug) {
                    this.log.debug("Enable lazy association support for: " + this.pool.getName());
                }
                this.supportsLazyAssociation = Boolean.TRUE;
            } else {
                if (this.debug) {
                    this.log.debug("Disable lazy association support for: " + this.pool.getName());
                }
                this.supportsLazyAssociation = Boolean.FALSE;
            }
        }
    }

    private boolean detachConnectionListener() {
        ConnectionListener cl = null;
        if (this.checkedOut.size() > 0) {
            cl = this.checkedOut.pollFirst();
        }
        if (cl != null && !cl.isEnlisted()) {
            try {
                if (this.trace) {
                    this.log.tracef("Detach: %s", cl);
                }
                DissociatableManagedConnection dmc = (DissociatableManagedConnection)cl.getManagedConnection();
                dmc.dissociateConnections();
                cl.unregisterConnections();
                this.returnConnection(cl, false, false);
                return true;
            }
            catch (Throwable t) {
                if (this.debug) {
                    this.log.debug("Exception during detach for: " + this.pool.getName(), t);
                }
                this.supportsLazyAssociation = Boolean.FALSE;
                this.returnConnection(cl, true, true);
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArrayBlockingQueueManagedConnectionPool@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[pool=").append(this.pool.getName());
        sb.append("]");
        return sb.toString();
    }
}

