/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementPosition;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.PositionStack;
import org.jboss.xb.binding.sunday.unmarshalling.RepeatableParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SundayContentHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public abstract class AbstractPosition {
    protected static Logger log = Logger.getLogger(AbstractPosition.class);
    protected static boolean trace;
    protected PositionStack stack;
    protected final QName qName;
    protected ParticleBinding particle;
    protected TermBinding term;
    protected ParticleHandler handler;
    protected TypeBinding parentType;
    protected Object o;
    protected Object repeatableParticleValue;
    protected RepeatableParticleHandler repeatableHandler;
    protected boolean ended;
    protected int occurrence;
    protected AbstractPosition previous;
    protected AbstractPosition next;
    protected AbstractPosition notSkippedParent;
    protected boolean skip;

    public static void resetTrace() {
        trace = log.isTraceEnabled();
    }

    protected AbstractPosition(QName qName, ParticleBinding particle) {
        if (particle == null) {
            throw new IllegalArgumentException("Null particle");
        }
        if (qName == null) {
            throw new IllegalArgumentException("Null qName");
        }
        this.qName = qName;
        this.particle = particle;
        this.occurrence = 1;
        this.term = particle.getTerm();
        this.skip = this.term.isSkip();
        if (particle.isRepeatable()) {
            this.repeatableHandler = this.term.getRepeatableHandler();
        }
        this.initHandler();
    }

    public void setStack(PositionStack stack) {
        this.stack = stack;
    }

    public ParticleBinding getParticle() {
        return this.particle;
    }

    public AbstractPosition getPrevious() {
        return this.previous;
    }

    public Object getRepeatableParticleValue() {
        return this.repeatableParticleValue;
    }

    public Object getValue() {
        return this.o;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public boolean isElement() {
        return false;
    }

    public void endRepeatableParticle() {
        if (trace) {
            log.trace((Object)(" end repeatable " + this.term));
        }
        this.repeatableHandler.endRepeatableParticle(this.previous.o, this.repeatableParticleValue, this.qName, this.particle, this.previous.particle);
        this.repeatableParticleValue = null;
    }

    public abstract void endParticle();

    public abstract void characters(char[] var1, int var2, int var3);

    public abstract ElementPosition startParticle(QName var1, Attributes var2);

    protected void initValue(Attributes atts) {
        Object parent = this.previous == null ? null : this.previous.o;
        this.o = this.handler.startParticle(parent, this.qName, this.particle, atts, this.stack.getNamespaceRegistry());
    }

    protected void startRepeatableParticle() {
        RepeatableParticleHandler repeatableHandler;
        Object repeatableContainer;
        if (trace) {
            log.trace((Object)(" start repeatable " + this.term));
        }
        if ((repeatableContainer = (repeatableHandler = this.term.getRepeatableHandler()).startRepeatableParticle(this.previous.o, this.qName, this.particle)) != null) {
            if (this.repeatableParticleValue != null) {
                throw new IllegalStateException("Previous repeatable particle hasn't been ended yet!");
            }
            this.repeatableParticleValue = repeatableContainer;
        }
    }

    protected AbstractPosition getLastNotSkipped() {
        return !this.skip || this.repeatableParticleValue != null ? this : this.notSkippedParent;
    }

    protected void setParent(AbstractPosition parentPosition, ParticleHandler handler) {
        if (this.skip) {
            return;
        }
        if (this.repeatableParticleValue != null) {
            this.repeatableHandler.addTermValue(this.repeatableParticleValue, this.o, this.qName, this.particle, parentPosition.particle, handler);
        } else if (parentPosition.repeatableParticleValue == null || !parentPosition.skip) {
            TermBeforeSetParentCallback beforeSetParent = this.term.getBeforeSetParentCallback();
            if (beforeSetParent != null) {
                SundayContentHandler.UnmarshallingContextImpl ctx = this.stack.getContext();
                ctx.parent = parentPosition.o;
                ctx.particle = this.particle;
                ctx.parentParticle = this.notSkippedParent.particle;
                this.o = beforeSetParent.beforeSetParent(this.o, ctx);
                ctx.clear();
            }
            handler.setParent(parentPosition.o, this.o, this.qName, this.particle, parentPosition.particle);
        } else {
            parentPosition.repeatableHandler.addTermValue(parentPosition.repeatableParticleValue, this.o, this.qName, this.particle, parentPosition.particle, handler);
        }
    }

    protected void initHandler() {
        this.handler = this.term.getHandler();
        if (this.handler == null) {
            this.handler = DefaultHandlers.ELEMENT_HANDLER;
        }
    }

    protected abstract void repeatForChild(Attributes var1);

    protected abstract AbstractPosition nextPosition(QName var1, Attributes var2);
}

