/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts;

import com.arjuna.ats.internal.jta.resources.jts.orbspecific.JTAInterposedSynchronizationImple;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import com.arjuna.ats.jta.exceptions.RollbackException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionSynchronizationRegistryImple
implements TransactionSynchronizationRegistry,
Serializable,
ObjectFactory {
    private static final long serialVersionUID = 1L;
    private transient TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        return this;
    }

    public Object getTransactionKey() {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.getTransactionKey");
        }
        TransactionImple transactionImple = null;
        try {
            transactionImple = (TransactionImple)this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_systemexception(), e);
        }
        if (transactionImple == null) {
            return null;
        }
        return transactionImple.get_uid();
    }

    public void putResource(Object key, Object value) {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.putResource");
        }
        if (key == null) {
            throw new NullPointerException();
        }
        TransactionImple transactionImple = this.getTransactionImple();
        transactionImple.putTxLocalResource(key, value);
    }

    public Object getResource(Object key) {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.getResource");
        }
        if (key == null) {
            throw new NullPointerException();
        }
        TransactionImple transactionImple = this.getTransactionImple();
        return transactionImple.getTxLocalResource(key);
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.registerInterposedSynchronization");
        }
        TransactionImple transactionImple = this.getTransactionImple();
        try {
            transactionImple.registerSynchronizationImple(new JTAInterposedSynchronizationImple(synchronization));
        }
        catch (javax.transaction.RollbackException e) {
            throw new RollbackException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_syncrollbackexception(), e);
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_systemexception(), e);
        }
    }

    public int getTransactionStatus() {
        try {
            return this.tm.getStatus();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_systemexception(), e);
        }
    }

    public void setRollbackOnly() {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.setRollbackOnly");
        }
        try {
            Transaction transaction = this.tm.getTransaction();
            if (transaction == null) {
                throw new IllegalStateException();
            }
            this.tm.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_systemexception(), e);
        }
    }

    public boolean getRollbackOnly() {
        TransactionImple transactionImple;
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionSynchronizationRegistryImple.getRollbackOnly");
        }
        if ((transactionImple = this.getTransactionImple()) == null) {
            throw new IllegalStateException();
        }
        try {
            return transactionImple.getStatus() == 1;
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_systemexception(), e);
        }
    }

    private TransactionImple getTransactionImple() throws IllegalStateException {
        TransactionImple transactionImple = null;
        try {
            transactionImple = (TransactionImple)this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_systemexception(), e);
        }
        try {
            if (transactionImple == null || transactionImple.getStatus() != 0 && transactionImple.getStatus() != 1) {
                throw new IllegalStateException("No transaction is running");
            }
        }
        catch (SystemException e) {
            throw new IllegalStateException("Could not get the status of a transaction");
        }
        return transactionImple;
    }
}

