/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.management.MBeanServer;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.journal.impl.AIOSequentialFileFactory;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.HornetQSecurityManagerAS7;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.JChannel;
import org.wildfly.security.manager.WildFlySecurityManager;

class HornetQService
implements Service<HornetQServer> {
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String LOGGING_FACTORY = "org.jboss.as.messaging.HornetQLoggerFactory";
    private static final String SOCKET_REF = RemoteTransportDefinition.SOCKET_BINDING.getName();
    private Configuration configuration;
    private HornetQServer server;
    private Map<String, SocketBinding> socketBindings = new HashMap<String, SocketBinding>();
    private Map<String, OutboundSocketBinding> outboundSocketBindings = new HashMap<String, OutboundSocketBinding>();
    private Map<String, SocketBinding> groupBindings = new HashMap<String, SocketBinding>();
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> securityDomainContextValue = new InjectedValue();
    private final PathConfig pathConfig;
    private final Map<String, String> jgroupsChannels = new HashMap<String, String>();
    private Map<String, ChannelFactory> jgroupFactories = new HashMap<String, ChannelFactory>();
    private final Map<String, JChannel> channels = new HashMap<String, JChannel>();

    public HornetQService(Configuration configuration, PathConfig pathConfig) {
        this.configuration = configuration;
        this.pathConfig = pathConfig;
    }

    Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }

    Injector<SocketBinding> getSocketBindingInjector(String name) {
        return new MapInjector(this.socketBindings, (Object)name);
    }

    Injector<ChannelFactory> getJGroupsInjector(String name) {
        return new MapInjector(this.jgroupFactories, (Object)name);
    }

    Injector<OutboundSocketBinding> getOutboundSocketBindingInjector(String name) {
        return new MapInjector(this.outboundSocketBindings, (Object)name);
    }

    Injector<SocketBinding> getGroupBindingInjector(String name) {
        return new MapInjector(this.groupBindings, (Object)name);
    }

    InjectedValue<MBeanServer> getMBeanServer() {
        return this.mbeanServer;
    }

    Map<String, JChannel> getChannels() {
        return this.channels;
    }

    public synchronized void start(StartContext context) throws StartException {
        boolean supportsAIO;
        ClassLoader origTCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        JournalType jtype = this.configuration.getJournalType();
        if (jtype == JournalType.ASYNCIO && !(supportsAIO = AIOSequentialFileFactory.isSupported())) {
            MessagingLogger.ROOT_LOGGER.aioWarning();
            this.configuration.setJournalType(JournalType.NIO);
        }
        this.configuration.setFileDeploymentEnabled(false);
        PathManager pathManager = (PathManager)this.pathManager.getValue();
        this.configuration.setBindingsDirectory(this.pathConfig.resolveBindingsPath(pathManager));
        this.configuration.setLargeMessagesDirectory(this.pathConfig.resolveLargeMessagePath(pathManager));
        this.configuration.setJournalDirectory(this.pathConfig.resolveJournalPath(pathManager));
        this.configuration.setPagingDirectory(this.pathConfig.resolvePagingPath(pathManager));
        try {
            JChannel channel;
            String channelName;
            String name;
            Object socketRef;
            Set acceptors = this.configuration.getAcceptorConfigurations();
            Collection connectors = this.configuration.getConnectorConfigurations().values();
            List broadcastGroups = this.configuration.getBroadcastGroupConfigurations();
            Map discoveryGroups = this.configuration.getDiscoveryGroupConfigurations();
            if (connectors != null) {
                for (TransportConfiguration transportConfiguration : connectors) {
                    String host;
                    int port;
                    socketRef = transportConfiguration.getParams().remove(SOCKET_REF);
                    if (socketRef == null) continue;
                    name = socketRef.toString();
                    OutboundSocketBinding binding = this.outboundSocketBindings.get(name);
                    if (binding == null) {
                        SocketBinding socketBinding = this.socketBindings.get(name);
                        if (socketBinding == null) {
                            throw MessagingMessages.MESSAGES.failedToFindConnectorSocketBinding(transportConfiguration.getName());
                        }
                        InetSocketAddress sa = socketBinding.getSocketAddress();
                        port = sa.getPort();
                        host = sa.getAddress().isLoopbackAddress() ? NetworkUtils.canonize((String)sa.getAddress().getHostName()) : NetworkUtils.canonize((String)sa.getAddress().getHostAddress());
                    } else {
                        port = binding.getDestinationPort();
                        host = NetworkUtils.canonize((String)binding.getUnresolvedDestinationAddress());
                        if (binding.getSourceAddress() != null) {
                            transportConfiguration.getParams().put("local-address", NetworkUtils.canonize((String)binding.getSourceAddress().getHostAddress()));
                        }
                        if (binding.getSourcePort() != null) {
                            transportConfiguration.getParams().put("local-port", binding.getSourcePort());
                        }
                    }
                    transportConfiguration.getParams().put(HOST, host);
                    transportConfiguration.getParams().put(PORT, String.valueOf(port));
                }
            }
            if (acceptors != null) {
                for (TransportConfiguration transportConfiguration : acceptors) {
                    socketRef = transportConfiguration.getParams().remove(SOCKET_REF);
                    if (socketRef == null) continue;
                    name = socketRef.toString();
                    SocketBinding binding = this.socketBindings.get(name);
                    if (binding == null) {
                        throw MessagingMessages.MESSAGES.failedToFindConnectorSocketBinding(transportConfiguration.getName());
                    }
                    InetSocketAddress socketAddress = binding.getSocketAddress();
                    transportConfiguration.getParams().put(HOST, socketAddress.getAddress().getHostAddress());
                    transportConfiguration.getParams().put(PORT, "" + socketAddress.getPort());
                }
            }
            if (broadcastGroups != null) {
                ArrayList<BroadcastGroupConfiguration> newConfigs = new ArrayList<BroadcastGroupConfiguration>();
                for (BroadcastGroupConfiguration config : broadcastGroups) {
                    name = config.getName();
                    String key = "broadcast" + name;
                    if (this.jgroupFactories.containsKey(key)) {
                        ChannelFactory channelFactory = this.jgroupFactories.get(key);
                        channelName = this.jgroupsChannels.get(key);
                        channel = (JChannel)channelFactory.createChannel(channelName);
                        this.channels.put(channelName, channel);
                        newConfigs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(name, config, channel, channelName));
                        continue;
                    }
                    SocketBinding binding = this.groupBindings.get(key);
                    if (binding == null) {
                        throw MessagingMessages.MESSAGES.failedToFindBroadcastSocketBinding(name);
                    }
                    newConfigs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(name, config, binding));
                }
                this.configuration.getBroadcastGroupConfigurations().clear();
                this.configuration.getBroadcastGroupConfigurations().addAll(newConfigs);
            }
            if (discoveryGroups != null) {
                this.configuration.setDiscoveryGroupConfigurations(new HashMap());
                for (Map.Entry entry : discoveryGroups.entrySet()) {
                    String name2 = (String)entry.getKey();
                    String key = "discovery" + name2;
                    DiscoveryGroupConfiguration config = null;
                    if (this.jgroupFactories.containsKey(key)) {
                        ChannelFactory channelFactory = this.jgroupFactories.get(key);
                        channelName = this.jgroupsChannels.get(key);
                        channel = this.channels.get(channelName);
                        if (channel == null) {
                            channel = (JChannel)channelFactory.createChannel(key);
                            this.channels.put(channelName, channel);
                        }
                        config = DiscoveryGroupAdd.createDiscoveryGroupConfiguration(name2, (DiscoveryGroupConfiguration)entry.getValue(), channel, channelName);
                    } else {
                        SocketBinding binding = this.groupBindings.get(key);
                        if (binding == null) {
                            throw MessagingMessages.MESSAGES.failedToFindDiscoverySocketBinding(name2);
                        }
                        config = DiscoveryGroupAdd.createDiscoveryGroupConfiguration(name2, (DiscoveryGroupConfiguration)entry.getValue(), binding);
                    }
                    this.configuration.getDiscoveryGroupConfigurations().put(name2, config);
                }
            }
            HornetQSecurityManagerAS7 hornetQSecurityManagerAS7 = new HornetQSecurityManagerAS7((SecurityDomainContext)this.securityDomainContextValue.getValue());
            this.server = new HornetQServerImpl(this.configuration, (MBeanServer)this.mbeanServer.getOptionalValue(), (HornetQSecurityManager)hornetQSecurityManagerAS7);
            if (HornetQDefaultConfiguration.getDefaultClusterPassword().equals(this.server.getConfiguration().getClusterPassword())) {
                this.server.getConfiguration().setClusterPassword(UUID.randomUUID().toString());
            }
        }
        catch (Exception e) {
            throw MessagingMessages.MESSAGES.failedToStartService(e);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)origTCCL);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            if (this.server != null) {
                // empty if block
            }
            this.pathConfig.closeCallbacks((PathManager)this.pathManager.getValue());
        }
        catch (Exception e) {
            throw MessagingMessages.MESSAGES.failedToShutdownServer(e, "HornetQ");
        }
    }

    public synchronized HornetQServer getValue() throws IllegalStateException {
        HornetQServer server = this.server;
        if (server == null) {
            throw new IllegalStateException();
        }
        return server;
    }

    public Injector<SecurityDomainContext> getSecurityDomainContextInjector() {
        return this.securityDomainContextValue;
    }

    public Map<String, String> getJGroupsChannels() {
        return this.jgroupsChannels;
    }

    static boolean isHornetQServiceInstalled(OperationContext context, ModelNode operation) {
        if (context.isNormalServer()) {
            ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
            ServiceController controller = context.getServiceRegistry(false).getService(hqServiceName);
            return controller != null;
        }
        return false;
    }

    static class PathConfig {
        private final String bindingsPath;
        private final String bindingsRelativeToPath;
        private final String journalPath;
        private final String journalRelativeToPath;
        private final String largeMessagePath;
        private final String largeMessageRelativeToPath;
        private final String pagingPath;
        private final String pagingRelativeToPath;
        private final List<PathManager.Callback.Handle> callbackHandles = new ArrayList<PathManager.Callback.Handle>();

        public PathConfig(String bindingsPath, String bindingsRelativeToPath, String journalPath, String journalRelativeToPath, String largeMessagePath, String largeMessageRelativeToPath, String pagingPath, String pagingRelativeToPath) {
            this.bindingsPath = bindingsPath;
            this.bindingsRelativeToPath = bindingsRelativeToPath;
            this.journalPath = journalPath;
            this.journalRelativeToPath = journalRelativeToPath;
            this.largeMessagePath = largeMessagePath;
            this.largeMessageRelativeToPath = largeMessageRelativeToPath;
            this.pagingPath = pagingPath;
            this.pagingRelativeToPath = pagingRelativeToPath;
        }

        String resolveBindingsPath(PathManager pathManager) {
            return this.resolve(pathManager, this.bindingsPath, this.bindingsRelativeToPath);
        }

        String resolveJournalPath(PathManager pathManager) {
            return this.resolve(pathManager, this.journalPath, this.journalRelativeToPath);
        }

        String resolveLargeMessagePath(PathManager pathManager) {
            return this.resolve(pathManager, this.largeMessagePath, this.largeMessageRelativeToPath);
        }

        String resolvePagingPath(PathManager pathManager) {
            return this.resolve(pathManager, this.pagingPath, this.pagingRelativeToPath);
        }

        String resolve(PathManager pathManager, String path, String relativeToPath) {
            String relativeTo = AbsolutePathService.isAbsoluteUnixOrWindowsPath((String)path) ? null : relativeToPath;
            return pathManager.resolveRelativePathEntry(path, relativeTo);
        }

        synchronized void registerCallbacks(PathManager pathManager) {
            if (this.bindingsRelativeToPath != null) {
                this.callbackHandles.add(pathManager.registerCallback(this.bindingsRelativeToPath, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED}));
            }
            if (this.journalRelativeToPath != null) {
                this.callbackHandles.add(pathManager.registerCallback(this.journalRelativeToPath, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED}));
            }
            if (this.largeMessageRelativeToPath != null) {
                this.callbackHandles.add(pathManager.registerCallback(this.largeMessageRelativeToPath, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED}));
            }
            if (this.pagingRelativeToPath != null) {
                this.callbackHandles.add(pathManager.registerCallback(this.pagingRelativeToPath, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED}));
            }
        }

        synchronized void closeCallbacks(PathManager pathManager) {
            for (PathManager.Callback.Handle callbackHandle : this.callbackHandles) {
                callbackHandle.remove();
            }
            this.callbackHandles.clear();
        }
    }
}

