/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Random;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.VerifyingLockFactory;

public class LockStressTest {
    public static void main(String[] args) throws Exception {
        int myID;
        if (args.length != 7) {
            System.out.println("Usage: java org.apache.lucene.store.LockStressTest myID verifierHost verifierPort lockFactoryClassName lockDirName sleepTimeMS count\n\n  myID = int from 0 .. 255 (should be unique for test process)\n  verifierHost = hostname that LockVerifyServer is listening on\n  verifierPort = port that LockVerifyServer is listening on\n  lockFactoryClassName = primary LockFactory class that we will use\n  lockDirName = path to the lock directory (only set for Simple/NativeFSLockFactory\n  sleepTimeMS = milliseconds to pause betweeen each lock obtain/release\n  count = number of locking tries\n\nYou should run multiple instances of this process, each with its own\nunique ID, and each pointing to the same lock directory, to verify\nthat locking is working correctly.\n\nMake sure you are first running LockVerifyServer.");
            System.exit(1);
        }
        int arg = 0;
        if ((myID = Integer.parseInt(args[arg++])) < 0 || myID > 255) {
            System.out.println("myID must be a unique int 0..255");
            System.exit(1);
        }
        String verifierHost = args[arg++];
        int verifierPort = Integer.parseInt(args[arg++]);
        String lockFactoryClassName = args[arg++];
        String lockDirName = args[arg++];
        int sleepTimeMS = Integer.parseInt(args[arg++]);
        int count = Integer.parseInt(args[arg++]);
        LockFactory lockFactory = LockStressTest.getNewLockFactory(lockFactoryClassName, lockDirName);
        InetSocketAddress addr = new InetSocketAddress(verifierHost, verifierPort);
        System.out.println("Connecting to server " + addr + " and registering as client " + myID + "...");
        try (Socket socket = new Socket();){
            socket.setReuseAddress(true);
            socket.connect(addr, 500);
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            out.write(myID);
            out.flush();
            VerifyingLockFactory verifyLF = new VerifyingLockFactory(lockFactory, in, out);
            Lock l = ((LockFactory)verifyLF).makeLock("test.lock");
            Random rnd = new Random();
            if (in.read() != 43) {
                throw new IOException("Protocol violation");
            }
            for (int i = 0; i < count; ++i) {
                boolean obtained = false;
                try {
                    obtained = l.obtain(rnd.nextInt(100) + 10);
                }
                catch (LockObtainFailedException e) {
                    // empty catch block
                }
                if (obtained) {
                    if (rnd.nextInt(10) == 0) {
                        Lock secondLock;
                        if (rnd.nextBoolean()) {
                            verifyLF = new VerifyingLockFactory(LockStressTest.getNewLockFactory(lockFactoryClassName, lockDirName), in, out);
                        }
                        if ((secondLock = ((LockFactory)verifyLF).makeLock("test.lock")).obtain()) {
                            throw new IOException("Double Obtain");
                        }
                    }
                    Thread.sleep(sleepTimeMS);
                    l.close();
                }
                if (i % 500 == 0) {
                    System.out.println((double)i * 100.0 / (double)count + "% done.");
                }
                Thread.sleep(sleepTimeMS);
            }
        }
        System.out.println("Finished " + count + " tries.");
    }

    private static LockFactory getNewLockFactory(String lockFactoryClassName, String lockDirName) throws IOException {
        LockFactory lockFactory;
        try {
            lockFactory = Class.forName(lockFactoryClassName).asSubclass(LockFactory.class).newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IOException("Cannot instantiate lock factory " + lockFactoryClassName);
        }
        File lockDir = new File(lockDirName);
        if (lockFactory instanceof FSLockFactory) {
            ((FSLockFactory)lockFactory).setLockDir(lockDir);
        }
        lockFactory.setLockPrefix("test");
        return lockFactory;
    }
}

