/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.util.Collections;
import java.util.List;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;

public final class FilterParsingResult<TypeMetadata> {
    private final BooleanExpr filter;
    private final String targetEntityName;
    private final TypeMetadata targetEntityMetadata;
    private final List<String> projections;
    private final List<SortField> sortFields;

    public FilterParsingResult(BooleanExpr filter, String targetEntityName, TypeMetadata targetEntityMetadata, List<String> projections, List<SortField> sortFields) {
        this.filter = filter;
        this.targetEntityName = targetEntityName;
        this.targetEntityMetadata = targetEntityMetadata;
        this.projections = projections != null ? projections : Collections.emptyList();
        this.sortFields = sortFields != null ? sortFields : Collections.emptyList();
    }

    public BooleanExpr getQuery() {
        return this.filter;
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public TypeMetadata getTargetEntityMetadata() {
        return this.targetEntityMetadata;
    }

    public List<String> getProjections() {
        return this.projections;
    }

    public List<SortField> getSortFields() {
        return this.sortFields;
    }

    public String toString() {
        return "FilterParsingResult [filter=" + this.filter + ", targetEntityName=" + this.targetEntityName + ", projections=" + this.projections + ", sortFields=" + this.sortFields + "]";
    }

    public static final class SortFieldImpl
    implements SortField {
        public final String path;
        public final boolean isAscending;

        public SortFieldImpl(String path, boolean isAscending) {
            this.path = path;
            this.isAscending = isAscending;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isAscending() {
            return this.isAscending;
        }

        public String toString() {
            return "SortField(" + this.path + ", " + (this.isAscending ? "ASC" : "DESC") + ')';
        }
    }
}

